/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.esql.action.ColumnInfoImpl;

public class XContentRowEncoder
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(XContentRowEncoder.class);
    private final XContentType xContentType;
    private final BlockFactory blockFactory;
    private final ColumnInfoImpl[] columnsInfo;
    private final EvalOperator.ExpressionEvaluator[] fieldsValueEvaluators;

    public static Factory yamlRowEncoderFactory(Map<ColumnInfoImpl, EvalOperator.ExpressionEvaluator.Factory> fieldsEvaluatorFactories) {
        return new Factory(XContentType.YAML, fieldsEvaluatorFactories);
    }

    private XContentRowEncoder(XContentType xContentType, BlockFactory blockFactory, ColumnInfoImpl[] columnsInfo, EvalOperator.ExpressionEvaluator[] fieldsValueEvaluators) {
        assert (columnsInfo.length == fieldsValueEvaluators.length);
        this.xContentType = xContentType;
        this.blockFactory = blockFactory;
        this.columnsInfo = columnsInfo;
        this.fieldsValueEvaluators = fieldsValueEvaluators;
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])this.fieldsValueEvaluators);
    }

    /*
     * Exception decompiling
     */
    public BytesRefBlock eval(Page page) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        for (EvalOperator.ExpressionEvaluator e : this.fieldsValueEvaluators) {
            baseRamBytesUsed += e.baseRamBytesUsed();
        }
        return baseRamBytesUsed;
    }

    public List<String> fieldNames() {
        return Arrays.stream(this.columnsInfo).map(ColumnInfoImpl::name).collect(Collectors.toList());
    }

    public String toString() {
        return "XContentRowEncoder[content_type=[" + this.xContentType.toString() + "], field_names=" + this.fieldNames() + "]";
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final XContentType xContentType;
        private final Map<ColumnInfoImpl, EvalOperator.ExpressionEvaluator.Factory> fieldsEvaluatorFactories;

        private Factory(XContentType xContentType, Map<ColumnInfoImpl, EvalOperator.ExpressionEvaluator.Factory> fieldsEvaluatorFactories) {
            this.xContentType = xContentType;
            this.fieldsEvaluatorFactories = fieldsEvaluatorFactories;
        }

        public XContentRowEncoder get(DriverContext context) {
            return new XContentRowEncoder(this.xContentType, context.blockFactory(), this.columnsInfo(), this.fieldsValueEvaluators(context));
        }

        private ColumnInfoImpl[] columnsInfo() {
            return (ColumnInfoImpl[])this.fieldsEvaluatorFactories.keySet().toArray(ColumnInfoImpl[]::new);
        }

        private EvalOperator.ExpressionEvaluator[] fieldsValueEvaluators(DriverContext context) {
            return (EvalOperator.ExpressionEvaluator[])this.fieldsEvaluatorFactories.values().stream().map(factory -> factory.get(context)).toArray(EvalOperator.ExpressionEvaluator[]::new);
        }
    }
}

