/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import java.util.Arrays;
import java.util.BitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class InBooleanEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(InBooleanEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator lhs;
    private final EvalOperator.ExpressionEvaluator[] rhs;
    private final DriverContext driverContext;
    private Warnings warnings;

    public InBooleanEvaluator(Source source, EvalOperator.ExpressionEvaluator lhs, EvalOperator.ExpressionEvaluator[] rhs, DriverContext driverContext) {
        this.source = source;
        this.lhs = lhs;
        this.rhs = rhs;
        this.driverContext = driverContext;
    }

    /*
     * Exception decompiling
     */
    public Block eval(Page page) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[FORLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BooleanBlock eval(int positionCount, BooleanBlock lhsBlock, BooleanBlock[] rhsBlocks) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            boolean hasTrue = false;
            boolean hasFalse = false;
            BitSet nulls = new BitSet(this.rhs.length);
            BitSet mvs = new BitSet(this.rhs.length);
            for (int p = 0; p < positionCount; ++p) {
                boolean foundMatch;
                if (lhsBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (lhsBlock.getValueCount(p) != 1) {
                    if (lhsBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                nulls.clear();
                mvs.clear();
                hasTrue = false;
                hasFalse = false;
                for (int i = 0; i < rhsBlocks.length; ++i) {
                    if (rhsBlocks[i].isNull(p)) {
                        nulls.set(i);
                        continue;
                    }
                    if (rhsBlocks[i].getValueCount(p) > 1) {
                        mvs.set(i);
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        continue;
                    }
                    if (hasTrue && hasFalse) continue;
                    int o = rhsBlocks[i].getFirstValueIndex(p);
                    if (rhsBlocks[i].getBoolean(o)) {
                        hasTrue = true;
                        continue;
                    }
                    hasFalse = true;
                }
                if (nulls.cardinality() == rhsBlocks.length || mvs.cardinality() == rhsBlocks.length) {
                    result.appendNull();
                    continue;
                }
                boolean bl = foundMatch = lhsBlock.getBoolean(lhsBlock.getFirstValueIndex(p)) ? hasTrue : hasFalse;
                if (foundMatch) {
                    result.appendBoolean(true);
                    continue;
                }
                if (nulls.cardinality() > 0) {
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(false);
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    private BooleanBlock eval(int positionCount, BooleanVector lhsVector, BooleanVector[] rhsVectors) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            boolean hasTrue = false;
            boolean hasFalse = false;
            for (int p = 0; p < positionCount; ++p) {
                hasTrue = false;
                hasFalse = false;
                for (int i = 0; i < rhsVectors.length; ++i) {
                    if (hasTrue && hasFalse) continue;
                    if (rhsVectors[i].getBoolean(p)) {
                        hasTrue = true;
                        continue;
                    }
                    hasFalse = true;
                }
                result.appendBoolean(lhsVector.getBoolean(p) ? hasTrue : hasFalse);
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public String toString() {
        return "InBooleanEvaluator[lhs=" + this.lhs + ", rhs=" + Arrays.toString(this.rhs) + "]";
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.lhs.baseRamBytesUsed();
        for (EvalOperator.ExpressionEvaluator r : this.rhs) {
            baseRamBytesUsed += r.baseRamBytesUsed();
        }
        return baseRamBytesUsed;
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.lhs, () -> Releasables.close((Releasable[])this.rhs)});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory lhs;
        private final EvalOperator.ExpressionEvaluator.Factory[] rhs;

        Factory(Source source, EvalOperator.ExpressionEvaluator.Factory lhs, EvalOperator.ExpressionEvaluator.Factory[] rhs) {
            this.source = source;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public InBooleanEvaluator get(DriverContext context) {
            EvalOperator.ExpressionEvaluator[] rhs = (EvalOperator.ExpressionEvaluator[])Arrays.stream(this.rhs).map(a -> a.get(context)).toArray(EvalOperator.ExpressionEvaluator[]::new);
            return new InBooleanEvaluator(this.source, this.lhs.get(context), rhs, context);
        }

        public String toString() {
            return "InBooleanEvaluator[lhs=" + this.lhs + ", rhs=" + Arrays.toString(this.rhs) + "]";
        }
    }
}

