/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.logical;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.expression.predicate.logical.And;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogicOperation;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Not;

public class Or
extends BinaryLogic
implements Negatable<BinaryLogic> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Or", Or::new);

    public Or(Source source, Expression left, Expression right) {
        super(source, left, right, BinaryLogicOperation.OR);
    }

    private Or(StreamInput in) throws IOException {
        super(in, BinaryLogicOperation.OR);
    }

    public String getWriteableName() {
        return Or.ENTRY.name;
    }

    protected NodeInfo<Or> info() {
        return NodeInfo.create((Node)this, Or::new, (Object)this.left(), (Object)this.right());
    }

    protected Or replaceChildren(Expression newLeft, Expression newRight) {
        return new Or(this.source(), newLeft, newRight);
    }

    public Or swapLeftAndRight() {
        return new Or(this.source(), this.right(), this.left());
    }

    public And negate() {
        return new And(this.source(), Not.negate(this.left()), Not.negate(this.right()));
    }

    protected Expression canonicalize() {
        return Predicates.combineOr(Predicates.splitOr(super.canonicalize()));
    }
}

