/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.security.NoSuchAlgorithmException;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Hash;

public final class HashEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(HashEvaluator.class);
    private final Source source;
    private final BreakingBytesRefBuilder scratch;
    private final EvalOperator.ExpressionEvaluator algorithm;
    private final EvalOperator.ExpressionEvaluator input;
    private final DriverContext driverContext;
    private Warnings warnings;

    public HashEvaluator(Source source, BreakingBytesRefBuilder scratch, EvalOperator.ExpressionEvaluator algorithm, EvalOperator.ExpressionEvaluator input, DriverContext driverContext) {
        this.source = source;
        this.scratch = scratch;
        this.algorithm = algorithm;
        this.input = input;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock algorithmBlock = (BytesRefBlock)this.algorithm.eval(page);){
            BytesRefBlock bytesRefBlock;
            block20: {
                BytesRefVector inputVector;
                BytesRefVector algorithmVector;
                BytesRefBlock inputBlock;
                block18: {
                    BytesRefBlock bytesRefBlock2;
                    block19: {
                        block16: {
                            BytesRefBlock bytesRefBlock3;
                            block17: {
                                inputBlock = (BytesRefBlock)this.input.eval(page);
                                try {
                                    algorithmVector = algorithmBlock.asVector();
                                    if (algorithmVector != null) break block16;
                                    bytesRefBlock3 = this.eval(page.getPositionCount(), algorithmBlock, inputBlock);
                                    if (inputBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (inputBlock != null) {
                                        try {
                                            inputBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                inputBlock.close();
                            }
                            return bytesRefBlock3;
                        }
                        inputVector = inputBlock.asVector();
                        if (inputVector != null) break block18;
                        bytesRefBlock2 = this.eval(page.getPositionCount(), algorithmBlock, inputBlock);
                        if (inputBlock == null) break block19;
                        inputBlock.close();
                    }
                    return bytesRefBlock2;
                }
                bytesRefBlock = this.eval(page.getPositionCount(), algorithmVector, inputVector);
                if (inputBlock == null) break block20;
                inputBlock.close();
            }
            return bytesRefBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.algorithm.baseRamBytesUsed();
        return baseRamBytesUsed += this.input.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock algorithmBlock, BytesRefBlock inputBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef algorithmScratch = new BytesRef();
            BytesRef inputScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (algorithmBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (algorithmBlock.getValueCount(p) != 1) {
                    if (algorithmBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (inputBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (inputBlock.getValueCount(p) != 1) {
                    if (inputBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendBytesRef(Hash.process(this.scratch, algorithmBlock.getBytesRef(algorithmBlock.getFirstValueIndex(p), algorithmScratch), inputBlock.getBytesRef(inputBlock.getFirstValueIndex(p), inputScratch)));
                    continue;
                }
                catch (NoSuchAlgorithmException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefVector algorithmVector, BytesRefVector inputVector) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef algorithmScratch = new BytesRef();
            BytesRef inputScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendBytesRef(Hash.process(this.scratch, algorithmVector.getBytesRef(p, algorithmScratch), inputVector.getBytesRef(p, inputScratch)));
                    continue;
                }
                catch (NoSuchAlgorithmException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "HashEvaluator[algorithm=" + this.algorithm + ", input=" + this.input + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.scratch, this.algorithm, this.input});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final Function<DriverContext, BreakingBytesRefBuilder> scratch;
        private final EvalOperator.ExpressionEvaluator.Factory algorithm;
        private final EvalOperator.ExpressionEvaluator.Factory input;

        public Factory(Source source, Function<DriverContext, BreakingBytesRefBuilder> scratch, EvalOperator.ExpressionEvaluator.Factory algorithm, EvalOperator.ExpressionEvaluator.Factory input) {
            this.source = source;
            this.scratch = scratch;
            this.algorithm = algorithm;
            this.input = input;
        }

        public HashEvaluator get(DriverContext context) {
            return new HashEvaluator(this.source, this.scratch.apply(context), this.algorithm.get(context), this.input.get(context), context);
        }

        public String toString() {
            return "HashEvaluator[algorithm=" + this.algorithm + ", input=" + this.input + "]";
        }
    }
}

