/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeotile;

public final class StGeotileFromFieldAndLiteralAndLiteralEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(StGeotileFromFieldAndLiteralAndLiteralEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator in;
    private final StGeotile.GeoTileBoundedGrid bounds;
    private final DriverContext driverContext;
    private Warnings warnings;

    public StGeotileFromFieldAndLiteralAndLiteralEvaluator(Source source, EvalOperator.ExpressionEvaluator in, StGeotile.GeoTileBoundedGrid bounds, DriverContext driverContext) {
        this.source = source;
        this.in = in;
        this.bounds = bounds;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock inBlock = (BytesRefBlock)this.in.eval(page);){
            LongBlock longBlock = this.eval(page.getPositionCount(), inBlock);
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.in.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, BytesRefBlock inBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!inBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    StGeotile.fromFieldAndLiteralAndLiteral(result, p, inBlock, this.bounds);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "StGeotileFromFieldAndLiteralAndLiteralEvaluator[in=" + this.in + ", bounds=" + this.bounds + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.in);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory in;
        private final StGeotile.GeoTileBoundedGrid bounds;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory in, StGeotile.GeoTileBoundedGrid bounds) {
            this.source = source;
            this.in = in;
            this.bounds = bounds;
        }

        public StGeotileFromFieldAndLiteralAndLiteralEvaluator get(DriverContext context) {
            return new StGeotileFromFieldAndLiteralAndLiteralEvaluator(this.source, this.in.get(context), this.bounds, context);
        }

        public String toString() {
            return "StGeotileFromFieldAndLiteralAndLiteralEvaluator[in=" + this.in + ", bounds=" + this.bounds + "]";
        }
    }
}

