/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohexToString;

public final class StGeohexToStringFromLongEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(StGeohexToStringFromLongEvaluator.class);
    private final EvalOperator.ExpressionEvaluator gridId;

    public StGeohexToStringFromLongEvaluator(Source source, EvalOperator.ExpressionEvaluator gridId, DriverContext driverContext) {
        super(driverContext, source);
        this.gridId = gridId;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.gridId;
    }

    @Override
    public Block evalVector(Vector v) {
        LongVector vector = (LongVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantBytesRefBlockWith(this.evalValue(vector, 0), positionCount);
        }
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendBytesRef(this.evalValue(vector, p));
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(LongVector container, int index) {
        long value = container.getLong(index);
        return StGeohexToString.fromLong(value);
    }

    @Override
    public Block evalBlock(Block b) {
        LongBlock block = (LongBlock)b;
        int positionCount = block.getPositionCount();
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    BytesRef value = this.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendBytesRef(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(LongBlock container, int index) {
        long value = container.getLong(index);
        return StGeohexToString.fromLong(value);
    }

    public String toString() {
        return "StGeohexToStringFromLongEvaluator[gridId=" + this.gridId + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.gridId);
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.gridId.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory gridId;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory gridId) {
            this.source = source;
            this.gridId = gridId;
        }

        public StGeohexToStringFromLongEvaluator get(DriverContext context) {
            return new StGeohexToStringFromLongEvaluator(this.source, this.gridId.get(context), context);
        }

        public String toString() {
            return "StGeohexToStringFromLongEvaluator[gridId=" + this.gridId + "]";
        }
    }
}

