/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohash;

public final class StGeohashFromFieldDocValuesAndLiteralEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(StGeohashFromFieldDocValuesAndLiteralEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator encoded;
    private final int precision;
    private final DriverContext driverContext;
    private Warnings warnings;

    public StGeohashFromFieldDocValuesAndLiteralEvaluator(Source source, EvalOperator.ExpressionEvaluator encoded, int precision, DriverContext driverContext) {
        this.source = source;
        this.encoded = encoded;
        this.precision = precision;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock encodedBlock = (LongBlock)this.encoded.eval(page);){
            LongBlock longBlock = this.eval(page.getPositionCount(), encodedBlock);
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.encoded.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock encodedBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!encodedBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    StGeohash.fromFieldDocValuesAndLiteral(result, p, encodedBlock, this.precision);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "StGeohashFromFieldDocValuesAndLiteralEvaluator[encoded=" + this.encoded + ", precision=" + this.precision + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.encoded);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory encoded;
        private final int precision;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory encoded, int precision) {
            this.source = source;
            this.encoded = encoded;
            this.precision = precision;
        }

        public StGeohashFromFieldDocValuesAndLiteralEvaluator get(DriverContext context) {
            return new StGeohashFromFieldDocValuesAndLiteralEvaluator(this.source, this.encoded.get(context), this.precision, context);
        }

        public String toString() {
            return "StGeohashFromFieldDocValuesAndLiteralEvaluator[encoded=" + this.encoded + ", precision=" + this.precision + "]";
        }
    }
}

