/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistance;

public final class StDistanceCartesianSourceAndSourceEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(StDistanceCartesianSourceAndSourceEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator left;
    private final EvalOperator.ExpressionEvaluator right;
    private final DriverContext driverContext;
    private Warnings warnings;

    public StDistanceCartesianSourceAndSourceEvaluator(Source source, EvalOperator.ExpressionEvaluator left, EvalOperator.ExpressionEvaluator right, DriverContext driverContext) {
        this.source = source;
        this.left = left;
        this.right = right;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock leftBlock = (BytesRefBlock)this.left.eval(page);){
            DoubleBlock doubleBlock;
            block12: {
                BytesRefBlock rightBlock = (BytesRefBlock)this.right.eval(page);
                try {
                    doubleBlock = this.eval(page.getPositionCount(), leftBlock, rightBlock);
                    if (rightBlock == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rightBlock != null) {
                        try {
                            rightBlock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rightBlock.close();
            }
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.left.baseRamBytesUsed();
        return baseRamBytesUsed += this.right.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, BytesRefBlock leftBlock, BytesRefBlock rightBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!leftBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (!rightBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    StDistance.processCartesianSourceAndSource(result, p, leftBlock, rightBlock);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "StDistanceCartesianSourceAndSourceEvaluator[left=" + this.left + ", right=" + this.right + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.left, this.right});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory left;
        private final EvalOperator.ExpressionEvaluator.Factory right;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory left, EvalOperator.ExpressionEvaluator.Factory right) {
            this.source = source;
            this.left = left;
            this.right = right;
        }

        public StDistanceCartesianSourceAndSourceEvaluator get(DriverContext context) {
            return new StDistanceCartesianSourceAndSourceEvaluator(this.source, this.left.get(context), this.right.get(context), context);
        }

        public String toString() {
            return "StDistanceCartesianSourceAndSourceEvaluator[left=" + this.left + ", right=" + this.right + "]";
        }
    }
}

