/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSumDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSumIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSumLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSumUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class MvSum
extends AbstractMultivalueFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvSum", MvSum::new);

    @FunctionInfo(returnType={"double", "integer", "long", "unsigned_long"}, description="Converts a multivalued field into a single valued field containing the sum of all of the values.", examples={@Example(file="math", tag="mv_sum")})
    public MvSum(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Multivalue expression.") Expression field) {
        super(source, field);
    }

    private MvSum(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return MvSum.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isType((Expression)this.field(), t -> t.isNumeric() && DataType.isRepresentable((DataType)t), (String)this.sourceText(), null, (String[])new String[]{"numeric"});
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return switch (PlannerUtils.toElementType(this.field().dataType())) {
            case ElementType.DOUBLE -> new MvSumDoubleEvaluator.Factory(fieldEval);
            case ElementType.INT -> new MvSumIntEvaluator.Factory(this.source(), fieldEval);
            case ElementType.LONG -> {
                if (this.field().dataType() == DataType.UNSIGNED_LONG) {
                    yield new MvSumUnsignedLongEvaluator.Factory(this.source(), fieldEval);
                }
                yield new MvSumLongEvaluator.Factory(this.source(), fieldEval);
            }
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvSum(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvSum::new, (Object)this.field());
    }

    public static void process(CompensatedSum sum, double v) {
        sum.add(v);
    }

    public static double finish(CompensatedSum sum) {
        double value = sum.value();
        sum.reset(0.0, 0.0);
        return value;
    }

    static int process(int current, int v) {
        return Math.addExact(current, v);
    }

    static long process(long current, long v) {
        return Math.addExact(current, v);
    }

    static long processUnsignedLong(long current, long v) {
        return NumericUtils.unsignedLongAddExact((long)current, (long)v);
    }
}

