/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.util.function.Function;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvPercentile;

public final class MvPercentileIntegerEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvPercentileIntegerEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator values;
    private final EvalOperator.ExpressionEvaluator percentile;
    private final MvPercentile.IntSortingScratch scratch;
    private final DriverContext driverContext;
    private Warnings warnings;

    public MvPercentileIntegerEvaluator(Source source, EvalOperator.ExpressionEvaluator values, EvalOperator.ExpressionEvaluator percentile, MvPercentile.IntSortingScratch scratch, DriverContext driverContext) {
        this.source = source;
        this.values = values;
        this.percentile = percentile;
        this.scratch = scratch;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock valuesBlock = (IntBlock)this.values.eval(page);){
            IntBlock intBlock;
            block12: {
                DoubleBlock percentileBlock = (DoubleBlock)this.percentile.eval(page);
                try {
                    intBlock = this.eval(page.getPositionCount(), valuesBlock, percentileBlock);
                    if (percentileBlock == null) break block12;
                }
                catch (Throwable throwable) {
                    if (percentileBlock != null) {
                        try {
                            percentileBlock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                percentileBlock.close();
            }
            return intBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.values.baseRamBytesUsed();
        return baseRamBytesUsed += this.percentile.baseRamBytesUsed();
    }

    public IntBlock eval(int positionCount, IntBlock valuesBlock, DoubleBlock percentileBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!valuesBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (percentileBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (percentileBlock.getValueCount(p) != 1) {
                    if (percentileBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    MvPercentile.process(result, p, valuesBlock, percentileBlock.getDouble(percentileBlock.getFirstValueIndex(p)), this.scratch);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public String toString() {
        return "MvPercentileIntegerEvaluator[values=" + this.values + ", percentile=" + this.percentile + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.values, this.percentile});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory values;
        private final EvalOperator.ExpressionEvaluator.Factory percentile;
        private final Function<DriverContext, MvPercentile.IntSortingScratch> scratch;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory values, EvalOperator.ExpressionEvaluator.Factory percentile, Function<DriverContext, MvPercentile.IntSortingScratch> scratch) {
            this.source = source;
            this.values = values;
            this.percentile = percentile;
            this.scratch = scratch;
        }

        public MvPercentileIntegerEvaluator get(DriverContext context) {
            return new MvPercentileIntegerEvaluator(this.source, this.values.get(context), this.percentile.get(context), this.scratch.apply(context), context);
        }

        public String toString() {
            return "MvPercentileIntegerEvaluator[values=" + this.values + ", percentile=" + this.percentile + "]";
        }
    }
}

