/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.util.function.Function;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvPSeriesWeightedSum;

public final class MvPSeriesWeightedSumDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvPSeriesWeightedSumDoubleEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator block;
    private final CompensatedSum sum;
    private final double p;
    private final DriverContext driverContext;
    private Warnings warnings;

    public MvPSeriesWeightedSumDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator block, CompensatedSum sum, double p, DriverContext driverContext) {
        this.source = source;
        this.block = block;
        this.sum = sum;
        this.p = p;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock blockBlock = (DoubleBlock)this.block.eval(page);){
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), blockBlock);
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.block.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, DoubleBlock blockBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!blockBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    MvPSeriesWeightedSum.process(result, p, blockBlock, this.sum, this.p);
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "MvPSeriesWeightedSumDoubleEvaluator[block=" + this.block + ", p=" + this.p + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.block);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory block;
        private final Function<DriverContext, CompensatedSum> sum;
        private final double p;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory block, Function<DriverContext, CompensatedSum> sum, double p) {
            this.source = source;
            this.block = block;
            this.sum = sum;
            this.p = p;
        }

        public MvPSeriesWeightedSumDoubleEvaluator get(DriverContext context) {
            return new MvPSeriesWeightedSumDoubleEvaluator(this.source, this.block.get(context), this.sum.apply(context), this.p, context);
        }

        public String toString() {
            return "MvPSeriesWeightedSumDoubleEvaluator[block=" + this.block + ", p=" + this.p + "]";
        }
    }
}

