/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedian;

public final class MvMedianDoubleEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvMedianDoubleEvaluator.class);

    public MvMedianDoubleEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvMedian";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNullable(fieldVal);
        }
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            MvMedian.Doubles work = new MvMedian.Doubles();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    double value = v.getDouble(i);
                    MvMedian.process(work, value);
                }
                double result = MvMedian.finish(work);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNotNullable(fieldVal);
        }
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleVector.FixedBuilder builder = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            MvMedian.Doubles work = new MvMedian.Doubles();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    double value = v.getDouble(i);
                    MvMedian.process(work, value);
                }
                double result = MvMedian.finish(work);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build().asBlock();
            return doubleBlock;
        }
    }

    private Block evalAscendingNullable(Block fieldVal) {
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            MvMedian.Doubles work = new MvMedian.Doubles();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                double result = MvMedian.ascending(v, first, valueCount);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private Block evalAscendingNotNullable(Block fieldVal) {
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleVector.FixedBuilder builder = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            MvMedian.Doubles work = new MvMedian.Doubles();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                double result = MvMedian.ascending(v, first, valueCount);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build().asBlock();
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        return BASE_RAM_BYTES_USED + this.field.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvMedianDoubleEvaluator get(DriverContext context) {
            return new MvMedianDoubleEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvMedian[field=" + this.field + "]";
        }
    }
}

