/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvFirst;

public final class MvFirstIntEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvFirstIntEvaluator.class);

    public MvFirstIntEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvFirst";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                int result = MvFirst.process(v, first, end);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntVector.FixedBuilder builder = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                int result = MvFirst.process(v, first, end);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build().asBlock();
            return intBlock;
        }
    }

    public long baseRamBytesUsed() {
        return BASE_RAM_BYTES_USED + this.field.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvFirstIntEvaluator get(DriverContext context) {
            return new MvFirstIntEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvFirst[field=" + this.field + "]";
        }
    }
}

