/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Scalb;

public final class ScalbConstantIntEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ScalbConstantIntEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator d;
    private final int scaleFactor;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ScalbConstantIntEvaluator(Source source, EvalOperator.ExpressionEvaluator d, int scaleFactor, DriverContext driverContext) {
        this.source = source;
        this.d = d;
        this.scaleFactor = scaleFactor;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock dBlock = (DoubleBlock)this.d.eval(page);){
            DoubleVector dVector = dBlock.asVector();
            if (dVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), dBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), dVector);
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.d.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, DoubleBlock dBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (dBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (dBlock.getValueCount(p) != 1) {
                    if (dBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendDouble(Scalb.processConstantInt(dBlock.getDouble(dBlock.getFirstValueIndex(p)), this.scaleFactor));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleVector dVector) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendDouble(Scalb.processConstantInt(dVector.getDouble(p), this.scaleFactor));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "ScalbConstantIntEvaluator[d=" + this.d + ", scaleFactor=" + this.scaleFactor + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.d);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory d;
        private final int scaleFactor;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory d, int scaleFactor) {
            this.source = source;
            this.d = d;
            this.scaleFactor = scaleFactor;
        }

        public ScalbConstantIntEvaluator get(DriverContext context) {
            return new ScalbConstantIntEvaluator(this.source, this.d.get(context), this.scaleFactor, context);
        }

        public String toString() {
            return "ScalbConstantIntEvaluator[d=" + this.d + ", scaleFactor=" + this.scaleFactor + "]";
        }
    }
}

