/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong;

public final class RoundToLongBinarySearchEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(RoundToLongBinarySearchEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final long[] points;
    private final DriverContext driverContext;
    private Warnings warnings;

    public RoundToLongBinarySearchEvaluator(Source source, EvalOperator.ExpressionEvaluator field, long[] points, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.points = points;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock fieldBlock = (LongBlock)this.field.eval(page);){
            LongVector fieldVector = fieldBlock.asVector();
            if (fieldVector == null) {
                LongBlock longBlock = this.eval(page.getPositionCount(), fieldBlock);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), fieldVector).asBlock();
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.field.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock fieldBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (fieldBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (fieldBlock.getValueCount(p) != 1) {
                    if (fieldBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendLong(RoundToLong.process(fieldBlock.getLong(fieldBlock.getFirstValueIndex(p)), this.points));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector fieldVector) {
        try (LongVector.FixedBuilder result = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendLong(p, RoundToLong.process(fieldVector.getLong(p), this.points));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "RoundToLongBinarySearchEvaluator[field=" + this.field + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.field);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final long[] points;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, long[] points) {
            this.source = source;
            this.field = field;
            this.points = points;
        }

        public RoundToLongBinarySearchEvaluator get(DriverContext context) {
            return new RoundToLongBinarySearchEvaluator(this.source, this.field.get(context), this.points, context);
        }

        public String toString() {
            return "RoundToLongBinarySearchEvaluator[field=" + this.field + "]";
        }
    }
}

