/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.Arrays;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundTo;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong1Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong2Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong3Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong4Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLongBinarySearchEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLongLinearSearchEvaluator;

class RoundToLong {
    static final RoundTo.Build BUILD = (source, field, points) -> {
        long[] f = points.stream().mapToLong(p -> ((Number)p).longValue()).toArray();
        Arrays.sort(f);
        return switch (f.length) {
            case 1 -> new RoundToLong1Evaluator.Factory(source, field, f[0]);
            case 2 -> new RoundToLong2Evaluator.Factory(source, field, f[0], f[1]);
            case 3 -> new RoundToLong3Evaluator.Factory(source, field, f[0], f[1], f[2]);
            case 4 -> new RoundToLong4Evaluator.Factory(source, field, f[0], f[1], f[2], f[3]);
            case 5, 6, 7, 8, 9, 10 -> new RoundToLongLinearSearchEvaluator.Factory(source, field, f);
            default -> new RoundToLongBinarySearchEvaluator.Factory(source, field, f);
        };
    };

    RoundToLong() {
    }

    static long processLinear(long field, long[] points) {
        for (int i = 1; i < points.length; ++i) {
            if (field >= points[i]) continue;
            return points[i - 1];
        }
        return points[points.length - 1];
    }

    static long process(long field, long[] points) {
        int idx = Arrays.binarySearch(points, field);
        return points[idx >= 0 ? idx : Math.max(0, -idx - 2)];
    }

    static long process(long field, long p0) {
        return p0;
    }

    static long process(long field, long p0, long p1) {
        if (field < p1) {
            return p0;
        }
        return p1;
    }

    static long process(long field, long p0, long p1, long p2) {
        if (field < p1) {
            return p0;
        }
        if (field < p2) {
            return p1;
        }
        return p2;
    }

    static long process(long field, long p0, long p1, long p2, long p3) {
        if (field < p1) {
            return p0;
        }
        if (field < p2) {
            return p1;
        }
        if (field < p3) {
            return p2;
        }
        return p3;
    }
}

