/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.Arrays;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundTo;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt1Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt2Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt3Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt4Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToIntBinarySearchEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToIntLinearSearchEvaluator;

class RoundToInt {
    static final RoundTo.Build BUILD = (source, field, points) -> {
        int[] f = points.stream().mapToInt(p -> ((Number)p).intValue()).toArray();
        Arrays.sort(f);
        return switch (f.length) {
            case 1 -> new RoundToInt1Evaluator.Factory(source, field, f[0]);
            case 2 -> new RoundToInt2Evaluator.Factory(source, field, f[0], f[1]);
            case 3 -> new RoundToInt3Evaluator.Factory(source, field, f[0], f[1], f[2]);
            case 4 -> new RoundToInt4Evaluator.Factory(source, field, f[0], f[1], f[2], f[3]);
            case 5, 6, 7, 8, 9, 10 -> new RoundToIntLinearSearchEvaluator.Factory(source, field, f);
            default -> new RoundToIntBinarySearchEvaluator.Factory(source, field, f);
        };
    };

    RoundToInt() {
    }

    static int processLinear(int field, int[] points) {
        for (int i = 1; i < points.length; ++i) {
            if (field >= points[i]) continue;
            return points[i - 1];
        }
        return points[points.length - 1];
    }

    static int process(int field, int[] points) {
        int idx = Arrays.binarySearch(points, field);
        return points[idx >= 0 ? idx : Math.max(0, -idx - 2)];
    }

    static int process(int field, int p0) {
        return p0;
    }

    static int process(int field, int p0, int p1) {
        if (field < p1) {
            return p0;
        }
        return p1;
    }

    static int process(int field, int p0, int p1, int p2) {
        if (field < p1) {
            return p0;
        }
        if (field < p2) {
            return p1;
        }
        return p2;
    }

    static int process(int field, int p0, int p1, int p2, int p3) {
        if (field < p1) {
            return p0;
        }
        if (field < p2) {
            return p1;
        }
        if (field < p3) {
            return p2;
        }
        return p3;
    }
}

