/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.time.ZoneId;
import java.time.temporal.ChronoField;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtract;

public final class DateExtractConstantMillisEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DateExtractConstantMillisEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator value;
    private final ChronoField chronoField;
    private final ZoneId zone;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DateExtractConstantMillisEvaluator(Source source, EvalOperator.ExpressionEvaluator value, ChronoField chronoField, ZoneId zone, DriverContext driverContext) {
        this.source = source;
        this.value = value;
        this.chronoField = chronoField;
        this.zone = zone;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock valueBlock = (LongBlock)this.value.eval(page);){
            LongVector valueVector = valueBlock.asVector();
            if (valueVector == null) {
                LongBlock longBlock = this.eval(page.getPositionCount(), valueBlock);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), valueVector).asBlock();
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.value.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock valueBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (valueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valueBlock.getValueCount(p) != 1) {
                    if (valueBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendLong(DateExtract.processMillis(valueBlock.getLong(valueBlock.getFirstValueIndex(p)), this.chronoField, this.zone));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector valueVector) {
        try (LongVector.FixedBuilder result = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendLong(p, DateExtract.processMillis(valueVector.getLong(p), this.chronoField, this.zone));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "DateExtractConstantMillisEvaluator[value=" + this.value + ", chronoField=" + this.chronoField + ", zone=" + this.zone + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.value);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory value;
        private final ChronoField chronoField;
        private final ZoneId zone;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory value, ChronoField chronoField, ZoneId zone) {
            this.source = source;
            this.value = value;
            this.chronoField = chronoField;
            this.zone = zone;
        }

        public DateExtractConstantMillisEvaluator get(DriverContext context) {
            return new DateExtractConstantMillisEvaluator(this.source, this.value.get(context), this.chronoField, this.zone, context);
        }

        public String toString() {
            return "DateExtractConstantMillisEvaluator[value=" + this.value + ", chronoField=" + this.chronoField + ", zone=" + this.zone + "]";
        }
    }
}

