/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiff;

public final class DateDiffConstantMillisEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DateDiffConstantMillisEvaluator.class);
    private final Source source;
    private final DateDiff.Part datePartFieldUnit;
    private final EvalOperator.ExpressionEvaluator startTimestamp;
    private final EvalOperator.ExpressionEvaluator endTimestamp;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DateDiffConstantMillisEvaluator(Source source, DateDiff.Part datePartFieldUnit, EvalOperator.ExpressionEvaluator startTimestamp, EvalOperator.ExpressionEvaluator endTimestamp, DriverContext driverContext) {
        this.source = source;
        this.datePartFieldUnit = datePartFieldUnit;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock startTimestampBlock = (LongBlock)this.startTimestamp.eval(page);){
            IntBlock intBlock;
            block20: {
                LongVector endTimestampVector;
                LongVector startTimestampVector;
                LongBlock endTimestampBlock;
                block18: {
                    IntBlock intBlock2;
                    block19: {
                        block16: {
                            IntBlock intBlock3;
                            block17: {
                                endTimestampBlock = (LongBlock)this.endTimestamp.eval(page);
                                try {
                                    startTimestampVector = startTimestampBlock.asVector();
                                    if (startTimestampVector != null) break block16;
                                    intBlock3 = this.eval(page.getPositionCount(), startTimestampBlock, endTimestampBlock);
                                    if (endTimestampBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (endTimestampBlock != null) {
                                        try {
                                            endTimestampBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                endTimestampBlock.close();
                            }
                            return intBlock3;
                        }
                        endTimestampVector = endTimestampBlock.asVector();
                        if (endTimestampVector != null) break block18;
                        intBlock2 = this.eval(page.getPositionCount(), startTimestampBlock, endTimestampBlock);
                        if (endTimestampBlock == null) break block19;
                        endTimestampBlock.close();
                    }
                    return intBlock2;
                }
                intBlock = this.eval(page.getPositionCount(), startTimestampVector, endTimestampVector);
                if (endTimestampBlock == null) break block20;
                endTimestampBlock.close();
            }
            return intBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.startTimestamp.baseRamBytesUsed();
        return baseRamBytesUsed += this.endTimestamp.baseRamBytesUsed();
    }

    public IntBlock eval(int positionCount, LongBlock startTimestampBlock, LongBlock endTimestampBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (startTimestampBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (startTimestampBlock.getValueCount(p) != 1) {
                    if (startTimestampBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (endTimestampBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (endTimestampBlock.getValueCount(p) != 1) {
                    if (endTimestampBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendInt(DateDiff.processMillis(this.datePartFieldUnit, startTimestampBlock.getLong(startTimestampBlock.getFirstValueIndex(p)), endTimestampBlock.getLong(endTimestampBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, LongVector startTimestampVector, LongVector endTimestampVector) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendInt(DateDiff.processMillis(this.datePartFieldUnit, startTimestampVector.getLong(p), endTimestampVector.getLong(p)));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public String toString() {
        return "DateDiffConstantMillisEvaluator[datePartFieldUnit=" + this.datePartFieldUnit + ", startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.startTimestamp, this.endTimestamp});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final DateDiff.Part datePartFieldUnit;
        private final EvalOperator.ExpressionEvaluator.Factory startTimestamp;
        private final EvalOperator.ExpressionEvaluator.Factory endTimestamp;

        public Factory(Source source, DateDiff.Part datePartFieldUnit, EvalOperator.ExpressionEvaluator.Factory startTimestamp, EvalOperator.ExpressionEvaluator.Factory endTimestamp) {
            this.source = source;
            this.datePartFieldUnit = datePartFieldUnit;
            this.startTimestamp = startTimestamp;
            this.endTimestamp = endTimestamp;
        }

        public DateDiffConstantMillisEvaluator get(DriverContext context) {
            return new DateDiffConstantMillisEvaluator(this.source, this.datePartFieldUnit, this.startTimestamp.get(context), this.endTimestamp.get(context), context);
        }

        public String toString() {
            return "DateDiffConstantMillisEvaluator[datePartFieldUnit=" + this.datePartFieldUnit + ", startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + "]";
        }
    }
}

