/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToString;

public final class ToStringFromVersionEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToStringFromVersionEvaluator.class);
    private final EvalOperator.ExpressionEvaluator version;

    public ToStringFromVersionEvaluator(Source source, EvalOperator.ExpressionEvaluator version, DriverContext driverContext) {
        super(driverContext, source);
        this.version = version;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.version;
    }

    @Override
    public Block evalVector(Vector v) {
        BytesRefVector vector = (BytesRefVector)v;
        OrdinalBytesRefVector ordinals = vector.asOrdinals();
        if (ordinals != null) {
            return this.evalOrdinals(ordinals);
        }
        int positionCount = v.getPositionCount();
        BytesRef scratchPad = new BytesRef();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantBytesRefBlockWith(this.evalValue(vector, 0, scratchPad), positionCount);
        }
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendBytesRef(this.evalValue(vector, p, scratchPad));
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(BytesRefVector container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return ToString.fromVersion(value);
    }

    @Override
    public Block evalBlock(Block b) {
        BytesRefBlock block = (BytesRefBlock)b;
        int positionCount = block.getPositionCount();
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef scratchPad = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    BytesRef value = this.evalValue(block, i, scratchPad);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendBytesRef(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(BytesRefBlock container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return ToString.fromVersion(value);
    }

    private Block evalOrdinals(OrdinalBytesRefVector v) {
        int positionCount = v.getDictionaryVector().getPositionCount();
        BytesRef scratchPad = new BytesRef();
        try (BytesRefVector.Builder builder = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendBytesRef(this.evalValue(v.getDictionaryVector(), p, scratchPad));
            }
            IntVector ordinals = v.getOrdinalsVector();
            ordinals.incRef();
            OrdinalBytesRefBlock ordinalBytesRefBlock = new OrdinalBytesRefVector(ordinals, builder.build()).asBlock();
            return ordinalBytesRefBlock;
        }
    }

    public String toString() {
        return "ToStringFromVersionEvaluator[version=" + this.version + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.version);
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.version.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory version;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory version) {
            this.source = source;
            this.version = version;
        }

        public ToStringFromVersionEvaluator get(DriverContext context) {
            return new ToStringFromVersionEvaluator(this.source, this.version.get(context), context);
        }

        public String toString() {
            return "ToStringFromVersionEvaluator[version=" + this.version + "]";
        }
    }
}

