/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToStringFromAggregateMetricDoubleEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToStringFromAggregateMetricDoubleEvaluator.class);
    private final EvalOperator.ExpressionEvaluator field;

    public ToStringFromAggregateMetricDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, source);
        this.field = field;
    }

    @Override
    protected EvalOperator.ExpressionEvaluator next() {
        return this.field;
    }

    public String toString() {
        return "ToStringFromAggregateMetricDouble[field=" + this.field + "]";
    }

    @Override
    protected Block evalVector(Vector v) {
        return this.evalBlock(v.asBlock());
    }

    private static BytesRef evalValue(AggregateMetricDoubleBlock aggBlock, int index) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.aggregateMetricDoubleBlockToString(aggBlock, index));
    }

    @Override
    public Block evalBlock(Block b) {
        AggregateMetricDoubleBlock block = (AggregateMetricDoubleBlock)b;
        int positionCount = block.getPositionCount();
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (block.isNull(p)) {
                    builder.appendNull();
                    continue;
                }
                builder.appendBytesRef(ToStringFromAggregateMetricDoubleEvaluator.evalValue(block, p));
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    public long baseRamBytesUsed() {
        return BASE_RAM_BYTES_USED + this.field.baseRamBytesUsed();
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.field);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field) {
            this.source = source;
            this.field = field;
        }

        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new ToStringFromAggregateMetricDoubleEvaluator(this.source, this.field.get(context), context);
        }
    }
}

