/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDateNanos;

public final class ToDateNanosFromLongEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToDateNanosFromLongEvaluator.class);
    private final EvalOperator.ExpressionEvaluator in;

    public ToDateNanosFromLongEvaluator(Source source, EvalOperator.ExpressionEvaluator in, DriverContext driverContext) {
        super(driverContext, source);
        this.in = in;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.in;
    }

    @Override
    public Block evalVector(Vector v) {
        LongVector vector = (LongVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            try {
                return this.driverContext.blockFactory().newConstantLongBlockWith(this.evalValue(vector, 0), positionCount);
            }
            catch (IllegalArgumentException e) {
                this.registerException(e);
                return this.driverContext.blockFactory().newConstantNullBlock(positionCount);
            }
        }
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    builder.appendLong(this.evalValue(vector, p));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.registerException(e);
                    builder.appendNull();
                }
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private long evalValue(LongVector container, int index) {
        long value = container.getLong(index);
        return ToDateNanos.fromLong(value);
    }

    @Override
    public Block evalBlock(Block b) {
        LongBlock block = (LongBlock)b;
        int positionCount = block.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    try {
                        long value = this.evalValue(block, i);
                        if (!positionOpened && valueCount > 1) {
                            builder.beginPositionEntry();
                            positionOpened = true;
                        }
                        builder.appendLong(value);
                        valuesAppended = true;
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.registerException(e);
                    }
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private long evalValue(LongBlock container, int index) {
        long value = container.getLong(index);
        return ToDateNanos.fromLong(value);
    }

    public String toString() {
        return "ToDateNanosFromLongEvaluator[in=" + this.in + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.in);
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.in.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory in;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory in) {
            this.source = source;
            this.in = in;
        }

        public ToDateNanosFromLongEvaluator get(DriverContext context) {
            return new ToDateNanosFromLongEvaluator(this.source, this.in.get(context), context);
        }

        public String toString() {
            return "ToDateNanosFromLongEvaluator[in=" + this.in + "]";
        }
    }
}

