/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBase64;

public final class ToBase64Evaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToBase64Evaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final BytesRefBuilder oScratch;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ToBase64Evaluator(Source source, EvalOperator.ExpressionEvaluator field, BytesRefBuilder oScratch, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.oScratch = oScratch;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock fieldBlock = (BytesRefBlock)this.field.eval(page);){
            BytesRefVector fieldVector = fieldBlock.asVector();
            if (fieldVector == null) {
                BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), fieldBlock);
                return bytesRefBlock;
            }
            BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), fieldVector);
            return bytesRefBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.field.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock fieldBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef fieldScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (fieldBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (fieldBlock.getValueCount(p) != 1) {
                    if (fieldBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendBytesRef(ToBase64.process(fieldBlock.getBytesRef(fieldBlock.getFirstValueIndex(p), fieldScratch), this.oScratch));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefVector fieldVector) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef fieldScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendBytesRef(ToBase64.process(fieldVector.getBytesRef(p, fieldScratch), this.oScratch));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "ToBase64Evaluator[field=" + this.field + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.field);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final Function<DriverContext, BytesRefBuilder> oScratch;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, Function<DriverContext, BytesRefBuilder> oScratch) {
            this.source = source;
            this.field = field;
            this.oScratch = oScratch;
        }

        public ToBase64Evaluator get(DriverContext context) {
            return new ToBase64Evaluator(this.source, this.field.get(context), this.oScratch.apply(context), context);
        }

        public String toString() {
            return "ToBase64Evaluator[field=" + this.field + "]";
        }
    }
}

