/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.AggregateMetricDoubleArrayBlock;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlock;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToAggregateMetricDouble
extends AbstractConvertFunction {
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.AGGREGATE_METRIC_DOUBLE, (source, fieldEval) -> fieldEval), Map.entry(DataType.DOUBLE, (source, fieldEval) -> new DoubleFactory(fieldEval)), Map.entry(DataType.INTEGER, (source, fieldEval) -> new IntFactory(fieldEval)), Map.entry(DataType.LONG, (source, fieldEval) -> new LongFactory(fieldEval)), Map.entry(DataType.UNSIGNED_LONG, (source, fieldEval) -> new UnsignedLongFactory(fieldEval)));
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToAggregateMetricDouble", ToAggregateMetricDouble::new);

    @FunctionInfo(returnType={"aggregate_metric_double"}, description="Encode a numeric to an aggregate_metric_double.", examples={@Example(file="convert", tag="toAggregateMetricDouble"), @Example(description="The expression also accepts multi-values", file="convert", tag="toAggregateMetricDoubleMv")})
    public ToAggregateMetricDouble(Source source, @Param(name="number", type={"double", "long", "unsigned_long", "integer", "aggregate_metric_double"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    private ToAggregateMetricDouble(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToAggregateMetricDouble.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isType((Expression)this.field, dt -> dt == DataType.AGGREGATE_METRIC_DOUBLE || dt == DataType.DOUBLE || dt == DataType.LONG || dt == DataType.INTEGER || dt == DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"numeric or aggregate_metric_double"});
    }

    @Override
    public DataType dataType() {
        return DataType.AGGREGATE_METRIC_DOUBLE;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToAggregateMetricDouble(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToAggregateMetricDouble::new, (Object)this.field);
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    public static class UnsignedLongFactory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory fieldEvaluator;

        public UnsignedLongFactory(EvalOperator.ExpressionEvaluator.Factory fieldEvaluator) {
            this.fieldEvaluator = fieldEvaluator;
        }

        public String toString() {
            return "ToAggregateMetricDoubleFromUnsignedLongEvaluator[field=" + this.fieldEvaluator + "]";
        }

        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new UnsignedLong(context.blockFactory(), this.fieldEvaluator.get(context));
        }
    }

    public static class LongFactory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory fieldEvaluator;

        public LongFactory(EvalOperator.ExpressionEvaluator.Factory fieldEvaluator) {
            this.fieldEvaluator = fieldEvaluator;
        }

        public String toString() {
            return "ToAggregateMetricDoubleFromLongEvaluator[field=" + this.fieldEvaluator + "]";
        }

        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new LongEvaluator(context.blockFactory(), this.fieldEvaluator.get(context));
        }
    }

    public static class IntFactory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory fieldEvaluator;

        public IntFactory(EvalOperator.ExpressionEvaluator.Factory fieldEvaluator) {
            this.fieldEvaluator = fieldEvaluator;
        }

        public String toString() {
            return "ToAggregateMetricDoubleFromIntEvaluator[field=" + this.fieldEvaluator + "]";
        }

        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new IntEvaluator(context.blockFactory(), this.fieldEvaluator.get(context));
        }
    }

    public static class DoubleFactory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory fieldEvaluator;

        public DoubleFactory(EvalOperator.ExpressionEvaluator.Factory fieldEvaluator) {
            this.fieldEvaluator = fieldEvaluator;
        }

        public String toString() {
            return "ToAggregateMetricDoubleFromDoubleEvaluator[field=" + this.fieldEvaluator + "]";
        }

        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new DoubleEvaluator(context.blockFactory(), this.fieldEvaluator.get(context));
        }
    }

    public record UnsignedLong(BlockFactory blockFactory, EvalOperator.ExpressionEvaluator eval) implements EvalOperator.ExpressionEvaluator
    {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(UnsignedLong.class);

        private Block evalBlock(Block block) {
            int positionCount = block.getPositionCount();
            LongBlock longBlock = (LongBlock)block;
            try (AggregateMetricDoubleBlockBuilder builder = this.blockFactory.newAggregateMetricDoubleBlockBuilder(positionCount);){
                CompensatedSum sum = new CompensatedSum();
                for (int p = 0; p < positionCount; ++p) {
                    int valueCount = longBlock.getValueCount(p);
                    int start = longBlock.getFirstValueIndex(p);
                    int end = start + valueCount;
                    if (valueCount == 0) {
                        builder.appendNull();
                        continue;
                    }
                    if (valueCount == 1) {
                        double current = EsqlDataTypeConverter.unsignedLongToDouble(longBlock.getLong(p));
                        builder.min().appendDouble(current);
                        builder.max().appendDouble(current);
                        builder.sum().appendDouble(current);
                        builder.count().appendInt(valueCount);
                        continue;
                    }
                    double min = Double.POSITIVE_INFINITY;
                    double max = Double.NEGATIVE_INFINITY;
                    for (int i = start; i < end; ++i) {
                        double current = EsqlDataTypeConverter.unsignedLongToDouble(longBlock.getLong(p));
                        min = Math.min(min, current);
                        max = Math.max(max, current);
                        sum.add(current);
                    }
                    builder.min().appendDouble(min);
                    builder.max().appendDouble(max);
                    builder.sum().appendDouble(sum.value());
                    builder.count().appendInt(valueCount);
                    sum.reset(0.0, 0.0);
                }
                AggregateMetricDoubleBlock aggregateMetricDoubleBlock = builder.build();
                return aggregateMetricDoubleBlock;
            }
        }

        private Block evalVector(Vector vector) {
            int positionCount = vector.getPositionCount();
            LongVector longVector = (LongVector)vector;
            try (AggregateMetricDoubleVectorBuilder builder = new AggregateMetricDoubleVectorBuilder(positionCount, this.blockFactory);){
                for (int p = 0; p < positionCount; ++p) {
                    double value = EsqlDataTypeConverter.unsignedLongToDouble(longVector.getLong(p));
                    builder.appendValue(value);
                }
                Block block = builder.build();
                return block;
            }
        }

        public Block eval(Page page) {
            try (Block block = this.eval.eval(page);){
                Vector vector = block.asVector();
                Block block2 = vector == null ? this.evalBlock(block) : this.evalVector(vector);
                return block2;
            }
        }

        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED + this.eval.baseRamBytesUsed();
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.eval);
        }

        @Override
        public String toString() {
            return "ToAggregateMetricDoubleFromUnsignedLongEvaluator[field=" + this.eval + "]";
        }
    }

    public record LongEvaluator(BlockFactory blockFactory, EvalOperator.ExpressionEvaluator eval) implements EvalOperator.ExpressionEvaluator
    {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LongEvaluator.class);

        private Block evalBlock(Block block) {
            int positionCount = block.getPositionCount();
            LongBlock longBlock = (LongBlock)block;
            try (AggregateMetricDoubleBlockBuilder builder = this.blockFactory.newAggregateMetricDoubleBlockBuilder(positionCount);){
                CompensatedSum sum = new CompensatedSum();
                for (int p = 0; p < positionCount; ++p) {
                    int valueCount = longBlock.getValueCount(p);
                    int start = longBlock.getFirstValueIndex(p);
                    int end = start + valueCount;
                    if (valueCount == 0) {
                        builder.appendNull();
                        continue;
                    }
                    if (valueCount == 1) {
                        double current = longBlock.getLong(start);
                        builder.min().appendDouble(current);
                        builder.max().appendDouble(current);
                        builder.sum().appendDouble(current);
                        builder.count().appendInt(valueCount);
                        continue;
                    }
                    double min = Double.POSITIVE_INFINITY;
                    double max = Double.NEGATIVE_INFINITY;
                    for (int i = start; i < end; ++i) {
                        double current = longBlock.getLong(i);
                        min = Math.min(min, current);
                        max = Math.max(max, current);
                        sum.add(current);
                    }
                    builder.min().appendDouble(min);
                    builder.max().appendDouble(max);
                    builder.sum().appendDouble(sum.value());
                    builder.count().appendInt(valueCount);
                    sum.reset(0.0, 0.0);
                }
                AggregateMetricDoubleBlock aggregateMetricDoubleBlock = builder.build();
                return aggregateMetricDoubleBlock;
            }
        }

        private Block evalVector(Vector vector) {
            int positionCount = vector.getPositionCount();
            LongVector longVector = (LongVector)vector;
            try (AggregateMetricDoubleVectorBuilder builder = new AggregateMetricDoubleVectorBuilder(positionCount, this.blockFactory);){
                for (int p = 0; p < positionCount; ++p) {
                    double value = longVector.getLong(p);
                    builder.appendValue(value);
                }
                Block block = builder.build();
                return block;
            }
        }

        public Block eval(Page page) {
            try (Block block = this.eval.eval(page);){
                Vector vector = block.asVector();
                Block block2 = vector == null ? this.evalBlock(block) : this.evalVector(vector);
                return block2;
            }
        }

        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED + this.eval.baseRamBytesUsed();
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.eval);
        }

        @Override
        public String toString() {
            return "ToAggregateMetricDoubleFromLongEvaluator[field=" + this.eval + "]";
        }
    }

    public record IntEvaluator(BlockFactory blockFactory, EvalOperator.ExpressionEvaluator eval) implements EvalOperator.ExpressionEvaluator
    {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntEvaluator.class);

        public Block eval(Page page) {
            try (Block block = this.eval.eval(page);){
                Vector vector = block.asVector();
                Block block2 = vector == null ? this.evalBlock(block) : this.evalVector(vector);
                return block2;
            }
        }

        private Block evalBlock(Block block) {
            int positionCount = block.getPositionCount();
            IntBlock intBlock = (IntBlock)block;
            try (AggregateMetricDoubleBlockBuilder builder = this.blockFactory.newAggregateMetricDoubleBlockBuilder(positionCount);){
                CompensatedSum sum = new CompensatedSum();
                for (int p = 0; p < positionCount; ++p) {
                    int valueCount = intBlock.getValueCount(p);
                    int start = intBlock.getFirstValueIndex(p);
                    int end = start + valueCount;
                    if (valueCount == 0) {
                        builder.appendNull();
                        continue;
                    }
                    if (valueCount == 1) {
                        double current = intBlock.getInt(start);
                        builder.min().appendDouble(current);
                        builder.max().appendDouble(current);
                        builder.sum().appendDouble(current);
                        builder.count().appendInt(valueCount);
                        continue;
                    }
                    double min = Double.POSITIVE_INFINITY;
                    double max = Double.NEGATIVE_INFINITY;
                    for (int i = start; i < end; ++i) {
                        double current = intBlock.getInt(i);
                        min = Math.min(min, current);
                        max = Math.max(max, current);
                        sum.add(current);
                    }
                    builder.min().appendDouble(min);
                    builder.max().appendDouble(max);
                    builder.sum().appendDouble(sum.value());
                    builder.count().appendInt(valueCount);
                    sum.reset(0.0, 0.0);
                }
                AggregateMetricDoubleBlock aggregateMetricDoubleBlock = builder.build();
                return aggregateMetricDoubleBlock;
            }
        }

        private Block evalVector(Vector vector) {
            int positionCount = vector.getPositionCount();
            IntVector intVector = (IntVector)vector;
            try (AggregateMetricDoubleVectorBuilder builder = new AggregateMetricDoubleVectorBuilder(positionCount, this.blockFactory);){
                for (int p = 0; p < positionCount; ++p) {
                    double value = intVector.getInt(p);
                    builder.appendValue(value);
                }
                Block block = builder.build();
                return block;
            }
        }

        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED + this.eval.baseRamBytesUsed();
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.eval);
        }

        @Override
        public String toString() {
            return "ToAggregateMetricDoubleFromIntEvaluator[field=" + this.eval + "]";
        }
    }

    public record DoubleEvaluator(BlockFactory blockFactory, EvalOperator.ExpressionEvaluator eval) implements EvalOperator.ExpressionEvaluator
    {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DoubleEvaluator.class);

        private Block evalBlock(Block block) {
            int positionCount = block.getPositionCount();
            DoubleBlock doubleBlock = (DoubleBlock)block;
            try (AggregateMetricDoubleBlockBuilder builder = this.blockFactory.newAggregateMetricDoubleBlockBuilder(positionCount);){
                CompensatedSum compensatedSum = new CompensatedSum();
                for (int p = 0; p < positionCount; ++p) {
                    int valueCount = doubleBlock.getValueCount(p);
                    if (valueCount == 0) {
                        builder.appendNull();
                        continue;
                    }
                    int start = doubleBlock.getFirstValueIndex(p);
                    int end = start + valueCount;
                    if (valueCount == 1) {
                        double current = doubleBlock.getDouble(start);
                        builder.min().appendDouble(current);
                        builder.max().appendDouble(current);
                        builder.sum().appendDouble(current);
                        builder.count().appendInt(valueCount);
                        continue;
                    }
                    double min = Double.POSITIVE_INFINITY;
                    double max = Double.NEGATIVE_INFINITY;
                    for (int i = start; i < end; ++i) {
                        double current = doubleBlock.getDouble(i);
                        min = Math.min(min, current);
                        max = Math.max(max, current);
                        compensatedSum.add(current);
                    }
                    builder.min().appendDouble(min);
                    builder.max().appendDouble(max);
                    builder.sum().appendDouble(compensatedSum.value());
                    builder.count().appendInt(valueCount);
                    compensatedSum.reset(0.0, 0.0);
                }
                AggregateMetricDoubleBlock aggregateMetricDoubleBlock = builder.build();
                return aggregateMetricDoubleBlock;
            }
        }

        private Block evalVector(Vector vector) {
            int positionCount = vector.getPositionCount();
            DoubleVector doubleVector = (DoubleVector)vector;
            try (AggregateMetricDoubleVectorBuilder builder = new AggregateMetricDoubleVectorBuilder(positionCount, this.blockFactory);){
                for (int p = 0; p < positionCount; ++p) {
                    double value = doubleVector.getDouble(p);
                    builder.appendValue(value);
                }
                Block block = builder.build();
                return block;
            }
        }

        public Block eval(Page page) {
            try (Block block = this.eval.eval(page);){
                Vector vector = block.asVector();
                Block block2 = vector == null ? this.evalBlock(block) : this.evalVector(vector);
                return block2;
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.eval);
        }

        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED + this.eval.baseRamBytesUsed();
        }

        @Override
        public String toString() {
            return "ToAggregateMetricDoubleFromDoubleEvaluator[field=" + this.eval + "]";
        }
    }

    private static class AggregateMetricDoubleVectorBuilder
    implements Releasable {
        private final DoubleVector.FixedBuilder valuesBuilder;
        private final BlockFactory blockFactory;

        private AggregateMetricDoubleVectorBuilder(int estimatedSize, BlockFactory blockFactory) {
            this.blockFactory = blockFactory;
            this.valuesBuilder = blockFactory.newDoubleVectorFixedBuilder(estimatedSize);
        }

        private void appendValue(double value) {
            this.valuesBuilder.appendDouble(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Block build() {
            AggregateMetricDoubleArrayBlock aggregateMetricDoubleArrayBlock;
            block3: {
                DoubleBlock doubleBlock = null;
                IntBlock countBlock = null;
                boolean success = false;
                try {
                    doubleBlock = this.valuesBuilder.build().asBlock();
                    countBlock = this.blockFactory.newConstantIntBlockWith(1, doubleBlock.getPositionCount());
                    AggregateMetricDoubleArrayBlock aggBlock = new AggregateMetricDoubleArrayBlock(doubleBlock, doubleBlock, doubleBlock, countBlock);
                    doubleBlock.incRef();
                    doubleBlock.incRef();
                    success = true;
                    aggregateMetricDoubleArrayBlock = aggBlock;
                    if (success) break block3;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.closeExpectNoException((Releasable[])new Releasable[]{doubleBlock, countBlock});
                    }
                    throw throwable;
                }
                Releasables.closeExpectNoException((Releasable[])new Releasable[]{doubleBlock, countBlock});
            }
            return aggregateMetricDoubleArrayBlock;
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.valuesBuilder);
        }
    }
}

