/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ParseIp;

public final class ParseIpLeadingZerosRejectedEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ParseIpLeadingZerosRejectedEvaluator.class);
    private final EvalOperator.ExpressionEvaluator string;
    private final BreakingBytesRefBuilder scratch;

    public ParseIpLeadingZerosRejectedEvaluator(Source source, EvalOperator.ExpressionEvaluator string, BreakingBytesRefBuilder scratch, DriverContext driverContext) {
        super(driverContext, source);
        this.string = string;
        this.scratch = scratch;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.string;
    }

    @Override
    public Block evalVector(Vector v) {
        BytesRefVector vector = (BytesRefVector)v;
        int positionCount = v.getPositionCount();
        BytesRef scratchPad = new BytesRef();
        if (vector.isConstant()) {
            try {
                return this.driverContext.blockFactory().newConstantBytesRefBlockWith(this.evalValue(vector, 0, scratchPad), positionCount);
            }
            catch (IllegalArgumentException e) {
                this.registerException(e);
                return this.driverContext.blockFactory().newConstantNullBlock(positionCount);
            }
        }
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    builder.appendBytesRef(this.evalValue(vector, p, scratchPad));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.registerException(e);
                    builder.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(BytesRefVector container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return ParseIp.leadingZerosRejected(value, this.scratch);
    }

    @Override
    public Block evalBlock(Block b) {
        BytesRefBlock block = (BytesRefBlock)b;
        int positionCount = block.getPositionCount();
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef scratchPad = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    try {
                        BytesRef value = this.evalValue(block, i, scratchPad);
                        if (!positionOpened && valueCount > 1) {
                            builder.beginPositionEntry();
                            positionOpened = true;
                        }
                        builder.appendBytesRef(value);
                        valuesAppended = true;
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.registerException(e);
                    }
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(BytesRefBlock container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return ParseIp.leadingZerosRejected(value, this.scratch);
    }

    public String toString() {
        return "ParseIpLeadingZerosRejectedEvaluator[string=" + this.string + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.string, this.scratch});
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.string.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory string;
        private final Function<DriverContext, BreakingBytesRefBuilder> scratch;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory string, Function<DriverContext, BreakingBytesRefBuilder> scratch) {
            this.source = source;
            this.string = string;
            this.scratch = scratch;
        }

        public ParseIpLeadingZerosRejectedEvaluator get(DriverContext context) {
            return new ParseIpLeadingZerosRejectedEvaluator(this.source, this.string.get(context), this.scratch.apply(context), context);
        }

        public String toString() {
            return "ParseIpLeadingZerosRejectedEvaluator[string=" + this.string + "]";
        }
    }
}

