/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.grouping;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationVerificationAware;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Foldables;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.Validations;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.TwoOptionalArguments;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTrunc;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Floor;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class Bucket
extends GroupingFunction.EvaluatableGroupingFunction
implements PostOptimizationVerificationAware,
TwoOptionalArguments {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Bucket", Bucket::new);
    private static final Rounding LARGEST_HUMAN_DATE_ROUNDING = Rounding.builder((Rounding.DateTimeUnit)Rounding.DateTimeUnit.YEAR_OF_CENTURY).build();
    private static final Rounding[] HUMAN_DATE_ROUNDINGS = new Rounding[]{Rounding.builder((Rounding.DateTimeUnit)Rounding.DateTimeUnit.MONTH_OF_YEAR).build(), Rounding.builder((Rounding.DateTimeUnit)Rounding.DateTimeUnit.WEEK_OF_WEEKYEAR).build(), Rounding.builder((Rounding.DateTimeUnit)Rounding.DateTimeUnit.DAY_OF_MONTH).build(), Rounding.builder((TimeValue)TimeValue.timeValueHours((long)12L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueHours((long)3L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueHours((long)1L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMinutes((long)30L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMinutes((long)10L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMinutes((long)5L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMinutes((long)1L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueSeconds((long)30L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueSeconds((long)10L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueSeconds((long)5L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueSeconds((long)1L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMillis((long)100L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMillis((long)50L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMillis((long)10L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMillis((long)1L)).build()};
    private static final ZoneId DEFAULT_TZ = ZoneOffset.UTC;
    private final Expression field;
    private final Expression buckets;
    private final Expression from;
    private final Expression to;

    @FunctionInfo(returnType={"double", "date", "date_nanos"}, description="Creates groups of values - buckets - out of a datetime or numeric input.\nThe size of the buckets can either be provided directly, or chosen based on a recommended count and values range.", examples={@Example(description="`BUCKET` can work in two modes: one in which the size of the bucket is computed\nbased on a buckets count recommendation (four parameters) and a range, and\nanother in which the bucket size is provided directly (two parameters).\n\nUsing a target number of buckets, a start of a range, and an end of a range,\n`BUCKET` picks an appropriate bucket size to generate the target number of buckets or fewer.\nFor example, asking for at most 20 buckets over a year results in monthly buckets:", file="bucket", tag="docsBucketMonth", explanation="The goal isn't to provide *exactly* the target number of buckets,\nit's to pick a range that people are comfortable with that provides at most the target number of buckets."), @Example(description="Combine `BUCKET` with an <<esql-agg-functions,aggregation>> to create a histogram:", file="bucket", tag="docsBucketMonthlyHistogram", explanation="NOTE: `BUCKET` does not create buckets that don't match any documents.\nThat's why this example is missing `1985-03-01` and other dates."), @Example(description="Asking for more buckets can result in a smaller range.\nFor example, asking for at most 100 buckets in a year results in weekly buckets:", file="bucket", tag="docsBucketWeeklyHistogram", explanation="NOTE: `BUCKET` does not filter any rows. It only uses the provided range to pick a good bucket size.\nFor rows with a value outside of the range, it returns a bucket value that corresponds to a bucket outside the range.\nCombine`BUCKET` with <<esql-where>> to filter rows."), @Example(description="If the desired bucket size is known in advance, simply provide it as the second\nargument, leaving the range out:", file="bucket", tag="docsBucketWeeklyHistogramWithSpan", explanation="NOTE: When providing the bucket size as the second parameter, it must be a time\nduration or date period."), @Example(description="`BUCKET` can also operate on numeric fields. For example, to create a salary histogram:", file="bucket", tag="docsBucketNumeric", explanation="Unlike the earlier example that intentionally filters on a date range, you rarely want to filter on a numeric range.\nYou have to find the `min` and `max` separately. {esql} doesn't yet have an easy way to do that automatically."), @Example(description="The range can be omitted if the desired bucket size is known in advance. Simply\nprovide it as the second argument:", file="bucket", tag="docsBucketNumericWithSpan"), @Example(description="Create hourly buckets for the last 24 hours, and calculate the number of events per hour:", file="bucket", tag="docsBucketLast24hr"), @Example(description="Create monthly buckets for the year 1985, and calculate the average salary by hiring month", file="bucket", tag="bucket_in_agg"), @Example(description="`BUCKET` may be used in both the aggregating and grouping part of the\n<<esql-stats-by, STATS ... BY ...>> command provided that in the aggregating\npart the function is referenced by an alias defined in the\ngrouping part, or that it is invoked with the exact same expression:", file="bucket", tag="reuseGroupingFunctionWithExpression"), @Example(description="Sometimes you need to change the start value of each bucket by a given duration (similar to date histogram\naggregation's <<search-aggregations-bucket-histogram-aggregation,`offset`>> parameter). To do so, you will need to\ntake into account how the language handles expressions within the `STATS` command: if these contain functions or\narithmetic operators, a virtual `EVAL` is inserted before and/or after the `STATS` command. Consequently, a double\ncompensation is needed to adjust the bucketed date value before the aggregation and then again after. For instance,\ninserting a negative offset of `1 hour` to buckets of `1 year` looks like this:", file="bucket", tag="bucketWithOffset")})
    public Bucket(Source source, @Param(name="field", type={"integer", "long", "double", "date", "date_nanos"}, description="Numeric or date expression from which to derive buckets.") Expression field, @Param(name="buckets", type={"integer", "long", "double", "date_period", "time_duration"}, description="Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.") Expression buckets, @Param(name="from", type={"integer", "long", "double", "date", "keyword", "text"}, optional=true, description="Start of the range. Can be a number, a date or a date expressed as a string.") Expression from, @Param(name="to", type={"integer", "long", "double", "date", "keyword", "text"}, optional=true, description="End of the range. Can be a number, a date or a date expressed as a string.") Expression to) {
        super(source, Bucket.fields(field, buckets, from, to));
        this.field = field;
        this.buckets = buckets;
        this.from = from;
        this.to = to;
    }

    private Bucket(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class));
    }

    private static List<Expression> fields(Expression field, Expression buckets, Expression from, Expression to) {
        ArrayList<Expression> list = new ArrayList<Expression>(4);
        list.add(field);
        list.add(buckets);
        if (from != null) {
            list.add(from);
            if (to != null) {
                list.add(to);
            }
        }
        return list;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeNamedWriteable((NamedWriteable)this.buckets);
        out.writeOptionalNamedWriteable((NamedWriteable)this.from);
        out.writeOptionalNamedWriteable((NamedWriteable)this.to);
    }

    public String getWriteableName() {
        return Bucket.ENTRY.name;
    }

    public boolean foldable() {
        return !(!this.field.foldable() || !this.buckets.foldable() || this.from != null && !this.from.foldable() || this.to != null && !this.to.foldable());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        if (this.field.dataType() == DataType.DATETIME || this.field.dataType() == DataType.DATE_NANOS) {
            Rounding.Prepared preparedRounding;
            if (this.buckets.dataType().isWholeNumber()) {
                int b = ((Number)this.buckets.fold(toEvaluator.foldCtx())).intValue();
                long f = this.foldToLong(toEvaluator.foldCtx(), this.from);
                long t = this.foldToLong(toEvaluator.foldCtx(), this.to);
                preparedRounding = new DateRoundingPicker(b, f, t).pickRounding().prepareForUnknown();
            } else {
                assert (DataType.isTemporalAmount((DataType)this.buckets.dataType())) : "Unexpected span data type [" + this.buckets.dataType() + "]";
                preparedRounding = DateTrunc.createRounding(this.buckets.fold(toEvaluator.foldCtx()), DEFAULT_TZ);
            }
            return DateTrunc.evaluator(this.field.dataType(), this.source(), toEvaluator.apply(this.field), preparedRounding);
        }
        if (this.field.dataType().isNumeric()) {
            double roundTo;
            if (this.from != null) {
                int b = ((Number)this.buckets.fold(toEvaluator.foldCtx())).intValue();
                double f = ((Number)this.from.fold(toEvaluator.foldCtx())).doubleValue();
                double t = ((Number)this.to.fold(toEvaluator.foldCtx())).doubleValue();
                roundTo = this.pickRounding(b, f, t);
            } else {
                roundTo = ((Number)this.buckets.fold(toEvaluator.foldCtx())).doubleValue();
            }
            Literal rounding = new Literal(this.source(), (Object)roundTo, DataType.DOUBLE);
            Div div = new Div(this.source(), this.field, (Expression)rounding);
            Floor floor = new Floor(this.source(), (Expression)div);
            Mul mul = new Mul(this.source(), (Expression)floor, (Expression)rounding);
            return toEvaluator.apply((Expression)mul);
        }
        throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
    }

    private double pickRounding(int buckets, double from, double to) {
        double precise = (to - from) / (double)buckets;
        double nextPowerOfTen = Math.pow(10.0, Math.ceil(Math.log10(precise)));
        double halfPower = nextPowerOfTen / 2.0;
        return precise < halfPower ? halfPower : nextPowerOfTen;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        DataType fieldType = this.field.dataType();
        DataType bucketsType = this.buckets.dataType();
        if (fieldType == DataType.NULL || bucketsType == DataType.NULL) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        if (fieldType == DataType.DATETIME || fieldType == DataType.DATE_NANOS) {
            Expression.TypeResolution resolution = TypeResolutions.isType((Expression)this.buckets, dt -> dt.isWholeNumber() || DataType.isTemporalAmount((DataType)dt), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"integral", "date_period", "time_duration"});
            return bucketsType.isWholeNumber() ? resolution.and(this.checkArgsCount(4)).and(() -> Bucket.isStringOrDate(this.from, this.sourceText(), TypeResolutions.ParamOrdinal.THIRD)).and(() -> Bucket.isStringOrDate(this.to, this.sourceText(), TypeResolutions.ParamOrdinal.FOURTH)) : resolution.and(this.checkArgsCount(2));
        }
        if (fieldType.isNumeric()) {
            return TypeResolutions.isNumeric((Expression)this.buckets, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND).and(() -> {
                if (bucketsType.isRationalNumber()) {
                    return this.checkArgsCount(2);
                }
                Expression.TypeResolution resolution = this.checkArgsCount(2);
                if (!resolution.resolved()) {
                    resolution = this.checkArgsCount(4).and(() -> TypeResolutions.isNumeric((Expression)this.from, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD)).and(() -> TypeResolutions.isNumeric((Expression)this.to, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FOURTH));
                }
                return resolution;
            });
        }
        return TypeResolutions.isType((Expression)this.field, e -> false, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"datetime", "numeric"});
    }

    private Expression.TypeResolution checkArgsCount(int expectedCount) {
        String expected = null;
        if (expectedCount == 2 && (this.from != null || this.to != null)) {
            expected = "two";
        } else if (expectedCount == 4 && (this.from == null || this.to == null)) {
            expected = "four";
        } else if (this.from == null && this.to != null || this.from != null && this.to == null) {
            expected = "two or four";
        }
        return expected == null ? Expression.TypeResolution.TYPE_RESOLVED : new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"function expects exactly {} arguments when the first one is of type [{}] and the second of type [{}]", (Object[])new Object[]{expected, this.field.dataType(), this.buckets.dataType()}));
    }

    private static Expression.TypeResolution isStringOrDate(Expression e, String operationName, TypeResolutions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType((Expression)e, exp -> DataType.isString((DataType)exp) || DataType.isDateTime((DataType)exp), (String)operationName, (TypeResolutions.ParamOrdinal)paramOrd, (String[])new String[]{"datetime", "string"});
    }

    @Override
    public void postOptimizationVerification(Failures failures) {
        String operation = this.sourceText();
        failures.add(Validations.isFoldable(this.buckets, operation, TypeResolutions.ParamOrdinal.SECOND)).add(this.from != null ? Validations.isFoldable(this.from, operation, TypeResolutions.ParamOrdinal.THIRD) : null).add(this.to != null ? Validations.isFoldable(this.to, operation, TypeResolutions.ParamOrdinal.FOURTH) : null);
    }

    private long foldToLong(FoldContext ctx, Expression e) {
        Object value = Foldables.valueOf((FoldContext)ctx, (Expression)e);
        return DataType.isDateTime((DataType)e.dataType()) ? ((Number)value).longValue() : EsqlDataTypeConverter.dateTimeToLong(((BytesRef)value).utf8ToString());
    }

    public DataType dataType() {
        if (this.field.dataType().isNumeric()) {
            return DataType.DOUBLE;
        }
        return this.field.dataType();
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        Expression from = newChildren.size() > 2 ? newChildren.get(2) : null;
        Expression to = newChildren.size() > 3 ? newChildren.get(3) : null;
        return new Bucket(this.source(), newChildren.get(0), newChildren.get(1), from, to);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Bucket::new, (Object)this.field, (Object)this.buckets, (Object)this.from, (Object)this.to);
    }

    public Expression field() {
        return this.field;
    }

    public Expression buckets() {
        return this.buckets;
    }

    public Expression from() {
        return this.from;
    }

    public Expression to() {
        return this.to;
    }

    public String toString() {
        return "Bucket{field=" + this.field + ", buckets=" + this.buckets + ", from=" + this.from + ", to=" + this.to + "}";
    }

    private record DateRoundingPicker(int buckets, long from, long to) {
        Rounding pickRounding() {
            Rounding prev = LARGEST_HUMAN_DATE_ROUNDING;
            for (Rounding r : HUMAN_DATE_ROUNDINGS) {
                if (!this.roundingIsOk(r)) {
                    return prev;
                }
                prev = r;
            }
            return prev;
        }

        boolean roundingIsOk(Rounding rounding) {
            Rounding.Prepared r = rounding.prepareForUnknown();
            long bucket = r.round(this.from);
            for (int used = 0; used < this.buckets; ++used) {
                bucket = r.nextRoundingValue(bucket);
                if (bucket < this.to) continue;
                return true;
            }
            return false;
        }
    }
}

