/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.lookup.QueryList;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.enrich.AbstractLookupService;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;

public class EnrichLookupService
extends AbstractLookupService<Request, TransportRequest> {
    public static final String LOOKUP_ACTION_NAME = "indices:data/read/esql/lookup";

    public EnrichLookupService(ClusterService clusterService, IndicesService indicesService, AbstractLookupService.LookupShardContextFactory lookupShardContextFactory, TransportService transportService, IndexNameExpressionResolver indexNameExpressionResolver, BigArrays bigArrays, BlockFactory blockFactory) {
        super(LOOKUP_ACTION_NAME, clusterService, indicesService, lookupShardContextFactory, transportService, indexNameExpressionResolver, bigArrays, blockFactory, true, TransportRequest::readFrom);
    }

    @Override
    protected TransportRequest transportRequest(Request request, ShardId shardId) {
        return new TransportRequest(request.sessionId, shardId, request.inputDataType, request.matchType, request.matchField, request.inputPage, null, request.extractFields, request.source);
    }

    @Override
    protected QueryList queryList(TransportRequest request, SearchExecutionContext context, AliasFilter aliasFilter, Block inputBlock, @Nullable DataType inputDataType) {
        MappedFieldType fieldType = context.getFieldType(request.matchField);
        EnrichLookupService.validateTypes(inputDataType, fieldType);
        return switch (request.matchType) {
            case "match", "range" -> EnrichLookupService.termQueryList(fieldType, context, aliasFilter, inputBlock, inputDataType);
            case "geo_match" -> QueryList.geoShapeQueryList((MappedFieldType)fieldType, (SearchExecutionContext)context, (AliasFilter)aliasFilter, (Block)inputBlock);
            default -> throw new EsqlIllegalArgumentException("illegal match type " + request.matchType);
        };
    }

    @Override
    protected LookupResponse createLookupResponse(List<Page> pages, BlockFactory blockFactory) throws IOException {
        if (pages.size() != 1) {
            throw new UnsupportedOperationException("ENRICH always makes a single page of output");
        }
        return new LookupResponse(pages.get(0), blockFactory);
    }

    @Override
    protected LookupResponse readLookupResponse(StreamInput in, BlockFactory blockFactory) throws IOException {
        return new LookupResponse(in, blockFactory);
    }

    private static void validateTypes(@Nullable DataType inputDataType, MappedFieldType fieldType) {
        if (fieldType instanceof RangeFieldMapper.RangeFieldType) {
            RangeFieldMapper.RangeFieldType rangeType = (RangeFieldMapper.RangeFieldType)fieldType;
            if (inputDataType != null && !EnrichLookupService.rangeTypesCompatible(rangeType.rangeType(), inputDataType)) {
                throw new EsqlIllegalArgumentException("ENRICH range and input types are incompatible: range[" + rangeType.rangeType() + "], input[" + inputDataType + "]");
            }
        }
    }

    private static boolean rangeTypesCompatible(RangeType rangeType, @Nullable DataType inputDataType) {
        if (inputDataType.noText() == DataType.KEYWORD) {
            return true;
        }
        return switch (rangeType) {
            case RangeType.INTEGER, RangeType.LONG -> inputDataType.isWholeNumber();
            case RangeType.IP -> {
                if (inputDataType == DataType.IP) {
                    yield true;
                }
                yield false;
            }
            case RangeType.DATE -> inputDataType.isDate();
            default -> rangeType.isNumeric() == inputDataType.isNumeric();
        };
    }

    @Override
    protected void sendChildRequest(CancellableTask parentTask, ActionListener<List<Page>> delegate, DiscoveryNode targetNode, TransportRequest transportRequest) {
        ThreadContext threadContext = this.transportService.getThreadPool().getThreadContext();
        ContextPreservingActionListener listener = ContextPreservingActionListener.wrapPreservingContext(delegate, (ThreadContext)threadContext);
        this.hasEnrichPrivilege((ActionListener<Void>)listener.delegateFailureAndWrap((l, ignored) -> {
            try (ThreadContext.StoredContext unused = threadContext.stashWithOrigin("enrich");){
                super.sendChildRequest(parentTask, (ActionListener<List<Page>>)l, targetNode, transportRequest);
            }
        }));
    }

    protected void hasEnrichPrivilege(ActionListener<Void> outListener) {
        Settings settings = this.clusterService.getSettings();
        String privilegeName = ClusterPrivilegeResolver.MONITOR_ENRICH.name();
        if (privilegeName == null || !settings.hasValue(XPackSettings.SECURITY_ENABLED.getKey()) || !((Boolean)XPackSettings.SECURITY_ENABLED.get(settings)).booleanValue()) {
            outListener.onResponse(null);
            return;
        }
        ThreadContext threadContext = this.transportService.getThreadPool().getThreadContext();
        SecurityContext securityContext = new SecurityContext(Settings.EMPTY, threadContext);
        User user = securityContext.getUser();
        if (user == null) {
            outListener.onFailure((Exception)new IllegalStateException("missing or unable to read authentication info on request"));
            return;
        }
        HasPrivilegesRequest request = new HasPrivilegesRequest();
        request.username(user.principal());
        request.clusterPrivileges(new String[]{privilegeName});
        request.indexPrivileges(new RoleDescriptor.IndicesPrivileges[0]);
        request.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
        ActionListener listener = outListener.delegateFailureAndWrap((l, resp) -> {
            if (resp.isCompleteMatch()) {
                l.onResponse(null);
                return;
            }
            String detailed = resp.getClusterPrivileges().entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(e -> "privilege [" + (String)e.getKey() + "] is missing").collect(Collectors.joining(", "));
            String message = "user [" + user.principal() + "] doesn't have sufficient privileges to perform enrich lookup: " + detailed;
            l.onFailure((Exception)Exceptions.authorizationError((String)message, (Object[])new Object[0]));
        });
        this.transportService.sendRequest(this.transportService.getLocalNode(), "cluster:admin/xpack/security/user/has_privileges", (org.elasticsearch.transport.TransportRequest)request, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(listener, HasPrivilegesResponse::new, this.executor));
    }

    protected static class TransportRequest
    extends AbstractLookupService.TransportRequest {
        private final String matchType;
        private final String matchField;

        TransportRequest(String sessionId, ShardId shardId, DataType inputDataType, String matchType, String matchField, Page inputPage, Page toRelease, List<NamedExpression> extractFields, Source source) {
            super(sessionId, shardId, shardId.getIndexName(), inputDataType, inputPage, toRelease, extractFields, source);
            this.matchType = matchType;
            this.matchField = matchField;
        }

        static TransportRequest readFrom(StreamInput in, BlockFactory blockFactory) throws IOException {
            Page inputPage;
            TaskId parentTaskId = TaskId.readFromStream((StreamInput)in);
            String sessionId = in.readString();
            ShardId shardId = new ShardId(in);
            DataType inputDataType = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0) ? DataType.fromTypeName((String)in.readString()) : null;
            String matchType = in.readString();
            String matchField = in.readString();
            try (BlockStreamInput bsi = new BlockStreamInput(in, blockFactory);){
                inputPage = new Page((StreamInput)bsi);
            }
            PlanStreamInput planIn = new PlanStreamInput(in, in.namedWriteableRegistry(), null);
            List extractFields = planIn.readNamedWriteableCollectionAsList(NamedExpression.class);
            Source source = Source.EMPTY;
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ENRICH_RUNTIME_WARNINGS)) {
                source = Source.readFrom((StreamInput)planIn);
            }
            TransportRequest result = new TransportRequest(sessionId, shardId, inputDataType, matchType, matchField, inputPage, inputPage, extractFields, source);
            result.setParentTask(parentTaskId);
            return result;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sessionId);
            out.writeWriteable((Writeable)this.shardId);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0)) {
                out.writeString(this.inputDataType.typeName());
            }
            out.writeString(this.matchType);
            out.writeString(this.matchField);
            out.writeWriteable((Writeable)this.inputPage);
            PlanStreamOutput planOut = new PlanStreamOutput(out, null);
            planOut.writeNamedWriteableCollection(this.extractFields);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ENRICH_RUNTIME_WARNINGS)) {
                this.source.writeTo((StreamOutput)planOut);
            }
        }

        @Override
        protected String extraDescription() {
            return " ,match_type=" + this.matchType + " ,match_field=" + this.matchField;
        }
    }

    public static class Request
    extends AbstractLookupService.Request {
        private final String matchType;
        private final String matchField;

        Request(String sessionId, String index, DataType inputDataType, String matchType, String matchField, Page inputPage, List<NamedExpression> extractFields, Source source) {
            super(sessionId, index, index, inputDataType, inputPage, extractFields, source);
            this.matchType = matchType;
            this.matchField = matchField;
        }
    }

    private static class LookupResponse
    extends AbstractLookupService.LookupResponse {
        private Page page;

        private LookupResponse(Page page, BlockFactory blockFactory) {
            super(blockFactory);
            this.page = page;
        }

        private LookupResponse(StreamInput in, BlockFactory blockFactory) throws IOException {
            super(blockFactory);
            try (BlockStreamInput bsi = new BlockStreamInput(in, blockFactory);){
                this.page = new Page((StreamInput)bsi);
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            long bytes = this.page.ramBytesUsedByBlocks();
            this.blockFactory.breaker().addEstimateBytesAndMaybeBreak(bytes, "serialize enrich lookup response");
            this.reservedBytes += bytes;
            this.page.writeTo(out);
        }

        @Override
        protected List<Page> takePages() {
            List<Page> p = List.of(this.page);
            this.page = null;
            return p;
        }

        @Override
        protected void innerRelease() {
            if (this.page != null) {
                Releasables.closeExpectNoException(() -> ((Page)this.page).releaseBlocks());
            }
        }
    }
}

