/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRule;
import org.elasticsearch.xpack.esql.rule.Rule;

public final class AnalyzerRules {
    public static List<Attribute> maybeResolveAgainstList(UnresolvedAttribute u, Collection<Attribute> attrList, Function<Attribute, Attribute> fieldInspector) {
        String name = u.name();
        Predicate<Attribute> predicate = a -> Objects.equals(name, a.name());
        return AnalyzerRules.maybeResolveAgainstList(predicate, () -> u, attrList, false, fieldInspector);
    }

    public static List<Attribute> maybeResolveAgainstList(Predicate<Attribute> matcher, Supplier<UnresolvedAttribute> unresolved, Collection<Attribute> attrList, boolean isPattern, Function<Attribute, Attribute> fieldInspector) {
        UnresolvedAttribute ua;
        ArrayList<Attribute> matches;
        block6: {
            block5: {
                matches = new ArrayList<Attribute>();
                for (Attribute attribute : attrList) {
                    boolean match;
                    if (attribute.synthetic() || !(match = matcher.test(attribute))) continue;
                    matches.add(attribute);
                }
                if (matches.isEmpty()) {
                    return matches;
                }
                ua = unresolved.get();
                if (matches.size() == 1) break block5;
                if (!isPattern) break block6;
            }
            matches.replaceAll(fieldInspector::apply);
            return matches;
        }
        List<String> refs = matches.stream().sorted((a, b) -> {
            int lineDiff = a.sourceLocation().getLineNumber() - b.sourceLocation().getLineNumber();
            int colDiff = a.sourceLocation().getColumnNumber() - b.sourceLocation().getColumnNumber();
            return lineDiff != 0 ? lineDiff : (colDiff != 0 ? colDiff : a.name().compareTo(b.name()));
        }).map(a -> "line " + a.sourceLocation().toString().substring(1) + " [" + a.name() + "]").toList();
        throw new IllegalStateException("Reference [" + ua.name() + "] is ambiguous; matches any of " + refs);
    }

    public static abstract class BaseAnalyzerRule
    extends AnalyzerRule<LogicalPlan> {
        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            if (!plan.childrenResolved()) {
                return plan;
            }
            return this.doRule(plan);
        }

        protected abstract LogicalPlan doRule(LogicalPlan var1);
    }

    public static abstract class ParameterizedAnalyzerRule<SubPlan extends LogicalPlan, P>
    extends ParameterizedRule<SubPlan, LogicalPlan, P> {
        @Override
        public final LogicalPlan apply(LogicalPlan plan, P context) {
            return (LogicalPlan)plan.transformUp(this.typeToken(), t -> t.analyzed() || this.skipResolved() && t.resolved() ? t : this.rule(t, context));
        }

        protected abstract LogicalPlan rule(SubPlan var1, P var2);

        protected boolean skipResolved() {
            return true;
        }
    }

    public static abstract class AnalyzerRule<SubPlan extends LogicalPlan>
    extends Rule<SubPlan, LogicalPlan> {
        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return (LogicalPlan)plan.transformUp(this.typeToken(), t -> t.analyzed() || this.skipResolved() && t.resolved() ? t : this.rule(t));
        }

        protected abstract LogicalPlan rule(SubPlan var1);

        protected boolean skipResolved() {
            return true;
        }
    }
}

