/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.logging.Level;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.xcontent.MediaType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.action.EsqlQueryResponse;
import org.elasticsearch.xpack.esql.arrow.ArrowFormat;
import org.elasticsearch.xpack.esql.arrow.ArrowResponse;
import org.elasticsearch.xpack.esql.formatter.TextFormat;
import org.elasticsearch.xpack.esql.plugin.EsqlMediaTypeParser;

public final class EsqlResponseListener
extends RestRefCountedChunkedToXContentListener<EsqlQueryResponse> {
    private static final Logger LOGGER = LogManager.getLogger(EsqlResponseListener.class);
    private static final String HEADER_NAME_TOOK_NANOS = "Took-nanos";
    private final RestChannel channel;
    private final RestRequest restRequest;
    private final MediaType mediaType;
    private final String esqlQueryOrId;
    private final ThreadSafeStopWatch stopWatch = new ThreadSafeStopWatch();

    public EsqlResponseListener(RestChannel channel, RestRequest restRequest, EsqlQueryRequest esqlRequest) {
        this(channel, restRequest, esqlRequest.query(), EsqlMediaTypeParser.getResponseMediaType(restRequest, esqlRequest));
    }

    public EsqlResponseListener(RestChannel channel, RestRequest getRequest) {
        this(channel, getRequest, getRequest.param("id"), EsqlMediaTypeParser.getResponseMediaType(getRequest, (MediaType)XContentType.JSON));
    }

    private EsqlResponseListener(RestChannel channel, RestRequest restRequest, String esqlQueryOrId, MediaType mediaType) {
        super(channel);
        this.channel = channel;
        this.restRequest = restRequest;
        this.esqlQueryOrId = esqlQueryOrId;
        this.mediaType = mediaType;
        this.checkDelimiter();
    }

    protected void processResponse(EsqlQueryResponse esqlQueryResponse) throws IOException {
        EsqlResponseListener.logPartialFailures(this.channel.request().rawPath(), this.channel.request().params(), esqlQueryResponse.getExecutionInfo());
        this.channel.sendResponse(this.buildResponse(esqlQueryResponse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestResponse buildResponse(EsqlQueryResponse esqlResponse) throws IOException {
        boolean success = false;
        Releasable releasable = this.releasableFromResponse((ChunkedToXContent)esqlResponse);
        try {
            RestResponse restResponse;
            MediaType mediaType = this.mediaType;
            if (mediaType instanceof TextFormat) {
                TextFormat format = (TextFormat)mediaType;
                restResponse = RestResponse.chunked((RestStatus)RestStatus.OK, (ChunkedRestResponseBodyPart)ChunkedRestResponseBodyPart.fromTextChunks((String)format.contentType(this.restRequest), format.format(this.restRequest, esqlResponse)), (Releasable)releasable);
            } else if (this.mediaType == ArrowFormat.INSTANCE) {
                ArrowResponse arrowResponse = new ArrowResponse(esqlResponse.columns().stream().map(c -> new ArrowResponse.Column(c.outputType(), c.name())).toList(), esqlResponse.pages());
                restResponse = RestResponse.chunked((RestStatus)RestStatus.OK, (ChunkedRestResponseBodyPart)arrowResponse, (Releasable)Releasables.wrap((Releasable[])new Releasable[]{arrowResponse, releasable}));
            } else {
                restResponse = RestResponse.chunked((RestStatus)RestStatus.OK, (ChunkedRestResponseBodyPart)ChunkedRestResponseBodyPart.fromXContent((ChunkedToXContent)esqlResponse, (ToXContent.Params)this.channel.request(), (RestChannel)this.channel), (Releasable)releasable);
            }
            restResponse.addHeader(HEADER_NAME_TOOK_NANOS, Long.toString(this.getTook(esqlResponse, TimeUnit.NANOSECONDS)));
            success = true;
            RestResponse restResponse2 = restResponse;
            return restResponse2;
        }
        finally {
            if (!success) {
                releasable.close();
            }
        }
    }

    private long getTook(EsqlQueryResponse esqlResponse, TimeUnit timeUnit) {
        assert (timeUnit == TimeUnit.NANOSECONDS || timeUnit == TimeUnit.MILLISECONDS) : "Unsupported TimeUnit: " + timeUnit;
        TimeValue tookTime = this.stopWatch.stop();
        if (esqlResponse != null && esqlResponse.getExecutionInfo() != null && esqlResponse.getExecutionInfo().overallTook() != null) {
            tookTime = esqlResponse.getExecutionInfo().overallTook();
        }
        if (timeUnit == TimeUnit.NANOSECONDS) {
            return tookTime.nanos();
        }
        return tookTime.millis();
    }

    public ActionListener<EsqlQueryResponse> wrapWithLogging() {
        ActionListener listener = ActionListener.wrap(arg_0 -> ((EsqlResponseListener)this).onResponse(arg_0), ex -> {
            EsqlResponseListener.logOnFailure(ex);
            this.onFailure((Exception)ex);
        });
        if (!LOGGER.isDebugEnabled()) {
            return listener;
        }
        Consumer<EsqlQueryResponse> logger = response -> LOGGER.debug("ESQL query execution {}.\nQuery string or async ID: [{}]\nExecution time: {}ms", new Object[]{response == null ? "failed" : "finished", this.esqlQueryOrId, this.getTook((EsqlQueryResponse)((Object)response), TimeUnit.MILLISECONDS)});
        return ActionListener.wrap(r -> {
            listener.onResponse((Object)r);
            logger.accept((EsqlQueryResponse)((Object)r));
        }, ex -> {
            logger.accept(null);
            listener.onFailure(ex);
        });
    }

    static void logOnFailure(Throwable throwable) {
        RestStatus status = ExceptionsHelper.status((Throwable)throwable);
        Level level = status.getStatus() >= 500 ? Level.WARN : Level.DEBUG;
        LOGGER.log(level, () -> "ESQL request failed with status [" + status + "]: ", throwable);
    }

    private void checkDelimiter() {
        if (this.mediaType != TextFormat.CSV && this.restRequest.hasParam("delimiter")) {
            String message = String.format(Locale.ROOT, "parameter: [%s] can only be used with the format [%s] for request [%s]", "delimiter", TextFormat.CSV.queryParameter(), this.restRequest.path());
            throw new IllegalArgumentException(message);
        }
    }

    static void logPartialFailures(String rawPath, Map<String, String> params, EsqlExecutionInfo executionInfo) {
        if (executionInfo == null) {
            return;
        }
        for (EsqlExecutionInfo.Cluster cluster : executionInfo.getClusters().values()) {
            for (ShardSearchFailure failure : cluster.getFailures()) {
                if (!LOGGER.isWarnEnabled()) continue;
                String clusterMessage = cluster.getClusterAlias().equals("") ? "" : ", cluster: " + cluster.getClusterAlias();
                LOGGER.warn("partial failure at path: {}, params: {}{}", new Object[]{rawPath, params, clusterMessage, failure});
            }
        }
    }

    private static class ThreadSafeStopWatch {
        private final long startTimeNS = System.nanoTime();
        private long endTimeNS;
        private boolean running = true;

        ThreadSafeStopWatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TimeValue stop() {
            ThreadSafeStopWatch threadSafeStopWatch = this;
            synchronized (threadSafeStopWatch) {
                if (this.running) {
                    this.endTimeNS = System.nanoTime();
                    this.running = false;
                }
                return new TimeValue(this.endTimeNS - this.startTimeNS, TimeUnit.NANOSECONDS);
            }
        }
    }
}

