/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.cli;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.lucene.util.SetOnce;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.cluster.coordination.ClusterBootstrapService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.cli.EnvironmentAwareCommand;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.PemUtils;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.SettingsBasedSeedHostsProvider;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.node.Node;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.CommandLineHttpClient;
import org.elasticsearch.xpack.core.security.EnrollmentToken;
import org.elasticsearch.xpack.core.security.HttpResponse;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;
import org.elasticsearch.xpack.security.cli.CertGenUtils;
import org.elasticsearch.xpack.security.cli.HttpCertificateCommand;

public class AutoConfigureNode
extends EnvironmentAwareCommand {
    public static final String AUTO_CONFIG_HTTP_ALT_DN = "CN=Elasticsearch security auto-configuration HTTP CA";
    public static final String AUTO_CONFIG_TRANSPORT_ALT_DN = "CN=Elasticsearch security auto-configuration transport CA";
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String TRANSPORT_AUTOGENERATED_KEYSTORE_NAME = "transport";
    private static final String TRANSPORT_KEY_KEYSTORE_ENTRY = "transport";
    private static final String TRANSPORT_CA_CERT_KEYSTORE_ENTRY = "transport_ca";
    private static final String ELASTICSEARCH_GROUP_OWNER = "elasticsearch";
    private static final int TRANSPORT_CERTIFICATE_DAYS = 36135;
    private static final int TRANSPORT_CA_CERTIFICATE_DAYS = 36135;
    private static final int TRANSPORT_KEY_SIZE = 4096;
    private static final int TRANSPORT_CA_KEY_SIZE = 4096;
    static final String HTTP_AUTOGENERATED_KEYSTORE_NAME = "http";
    static final String HTTP_KEY_KEYSTORE_ENTRY = "http";
    static final String HTTP_CA_KEY_KEYSTORE_ENTRY = "http_ca";
    static final String HTTP_AUTOGENERATED_CA_NAME = "http_ca";
    private static final int HTTP_CA_CERTIFICATE_DAYS = 1095;
    private static final int HTTP_CA_KEY_SIZE = 4096;
    private static final int HTTP_CERTIFICATE_DAYS = 730;
    private static final int HTTP_KEY_SIZE = 4096;
    static final String TLS_GENERATED_CERTS_DIR_NAME = "certs";
    static final String AUTO_CONFIGURATION_START_MARKER = "#----------------------- BEGIN SECURITY AUTO CONFIGURATION -----------------------";
    static final String AUTO_CONFIGURATION_END_MARKER = "#----------------------- END SECURITY AUTO CONFIGURATION -------------------------";
    private final OptionSpec<String> enrollmentTokenParam;
    private final boolean inReconfigureMode;
    private final BiFunction<Environment, String, CommandLineHttpClient> clientFunction;

    public AutoConfigureNode(boolean reconfigure, BiFunction<Environment, String, CommandLineHttpClient> clientFunction) {
        super("Generates all the necessary security configuration for a node in a secured cluster");
        this.enrollmentTokenParam = this.parser.accepts("enrollment-token", "The enrollment token to use").withRequiredArg();
        this.parser.allowsUnrecognizedOptions();
        this.inReconfigureMode = reconfigure;
        this.clientFunction = clientFunction;
    }

    public AutoConfigureNode(boolean reconfigure) {
        this(reconfigure, CommandLineHttpClient::new);
    }

    public void execute(Terminal terminal, OptionSet options, Environment env, ProcessInfo processInfo) throws Exception {
        X509Certificate httpCert;
        PrivateKey httpKey;
        X509Certificate transportCert;
        PrivateKey transportKey;
        X509Certificate httpCaCert;
        PrivateKey httpCaKey;
        X509Certificate transportCaCert;
        List<Object> transportAddresses;
        Path keystorePath;
        boolean inEnrollmentMode = options.has(this.enrollmentTokenParam);
        for (Path dataPath : env.dataDirs()) {
            if (!Files.isDirectory(dataPath, new LinkOption[0]) || AutoConfigureNode.isDirEmpty(dataPath)) continue;
            String msg = "Skipping security auto configuration because it appears that the node is not starting up for the first time. The node might already be part of a cluster and this auto setup utility is designed to configure Security for new clusters only.";
            AutoConfigureNode.notifyOfFailure(inEnrollmentMode, terminal, Terminal.Verbosity.VERBOSE, 80, "Skipping security auto configuration because it appears that the node is not starting up for the first time. The node might already be part of a cluster and this auto setup utility is designed to configure Security for new clusters only.");
        }
        Path ymlPath = env.configDir().resolve("elasticsearch.yml");
        if (!Files.exists(ymlPath, new LinkOption[0]) || !Files.isRegularFile(ymlPath, LinkOption.NOFOLLOW_LINKS)) {
            String msg = String.format(Locale.ROOT, "Skipping security auto configuration because the configuration file [%s] is missing or is not a regular file", ymlPath);
            AutoConfigureNode.notifyOfFailure(inEnrollmentMode, terminal, Terminal.Verbosity.NORMAL, 78, msg);
        }
        if (!Files.isReadable(ymlPath)) {
            String msg = String.format(Locale.ROOT, "Skipping security auto configuration because the current user does not have permission to read  configuration file [%s]", ymlPath);
            AutoConfigureNode.notifyOfFailure(inEnrollmentMode, terminal, Terminal.Verbosity.NORMAL, 80, msg);
        }
        if (!(!Files.exists(keystorePath = KeyStoreWrapper.keystorePath((Path)env.configDir()), new LinkOption[0]) || Files.isRegularFile(keystorePath, LinkOption.NOFOLLOW_LINKS) && Files.isReadable(keystorePath))) {
            String msg = String.format(Locale.ROOT, "Skipping security auto configuration because the node keystore file [%s] is not a readable regular file", keystorePath);
            AutoConfigureNode.notifyOfFailure(inEnrollmentMode, terminal, Terminal.Verbosity.NORMAL, 80, msg);
        }
        if (this.inReconfigureMode) {
            if (!inEnrollmentMode) {
                throw new UserException(64, "enrollment-token is a mandatory parameter when reconfiguring the node");
            }
            env = this.possiblyReconfigureNode(env, terminal, options, processInfo);
        }
        this.checkExistingConfiguration(env.settings(), inEnrollmentMode, terminal);
        ZonedDateTime autoConfigDate = ZonedDateTime.now(ZoneOffset.UTC);
        Path tempGeneratedTlsCertsDir = env.configDir().resolve(String.format(Locale.ROOT, "certs.%d.tmp", autoConfigDate.toInstant().getEpochSecond()));
        try {
            Files.createDirectory(tempGeneratedTlsCertsDir, new FileAttribute[0]);
            PosixFileAttributeView view = Files.getFileAttributeView(tempGeneratedTlsCertsDir, PosixFileAttributeView.class, new LinkOption[0]);
            if (view != null) {
                view.setPermissions(PosixFilePermissions.fromString("rwxr-x---"));
            }
        }
        catch (Throwable t) {
            try {
                AutoConfigureNode.deleteDirectory(tempGeneratedTlsCertsDir);
            }
            catch (Exception ex) {
                t.addSuppressed(ex);
            }
            throw new UserException(73, "Could not create auto-configuration directory", t);
        }
        UserPrincipal newFileOwner = Files.getOwner(tempGeneratedTlsCertsDir, LinkOption.NOFOLLOW_LINKS);
        if (!newFileOwner.equals(Files.getOwner(env.configDir(), LinkOption.NOFOLLOW_LINKS))) {
            UserException userException = new UserException(78, "Aborting auto configuration because of config dir ownership mismatch. Config dir is owned by " + Files.getOwner(env.configDir(), LinkOption.NOFOLLOW_LINKS).getName() + " but auto-configuration directory would be owned by " + newFileOwner.getName());
            try {
                AutoConfigureNode.deleteDirectory(tempGeneratedTlsCertsDir);
            }
            catch (Exception ex) {
                userException.addSuppressed((Throwable)ex);
            }
            throw userException;
        }
        String cnValue = Node.NODE_NAME_SETTING.exists(env.settings()) ? (String)Node.NODE_NAME_SETTING.get(env.settings()) : System.getenv("HOSTNAME");
        X500Principal certificatePrincipal = new X500Principal("CN=" + cnValue);
        X500Principal httpCaPrincipal = new X500Principal(AUTO_CONFIG_HTTP_ALT_DN);
        X500Principal transportCaPrincipal = new X500Principal(AUTO_CONFIG_TRANSPORT_ALT_DN);
        if (inEnrollmentMode) {
            String transportCertPem;
            String transportCaCertPem;
            String transportKeyPem;
            String httpCaCertPem;
            EnrollmentToken enrollmentToken;
            try {
                enrollmentToken = EnrollmentToken.decodeFromString((String)((String)this.enrollmentTokenParam.value(options)));
            }
            catch (Exception e) {
                try {
                    AutoConfigureNode.deleteDirectory(tempGeneratedTlsCertsDir);
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "Failed to parse enrollment token : " + (String)this.enrollmentTokenParam.value(options) + " . Error was: " + e.getMessage());
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, ExceptionsHelper.stackTrace((Throwable)e));
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
                throw new UserException(65, "Aborting auto configuration. Invalid enrollment token", (Throwable)e);
            }
            CommandLineHttpClient client = this.clientFunction.apply(env, enrollmentToken.getFingerprint());
            HttpResponse enrollResponse = null;
            URL enrollNodeUrl = null;
            for (String address : enrollmentToken.getBoundAddress()) {
                try {
                    enrollNodeUrl = CommandLineHttpClient.createURL((URL)new URL("https://" + address), (String)"/_security/enroll/node", (String)"");
                    enrollResponse = client.execute("GET", enrollNodeUrl, new SecureString(enrollmentToken.getApiKey().toCharArray()), () -> null, CommandLineHttpClient::responseBuilder);
                    break;
                }
                catch (Exception e) {
                    terminal.errorPrint(Terminal.Verbosity.NORMAL, "Unable to communicate with the node on " + enrollNodeUrl + ". Error was " + e.getMessage());
                }
            }
            if (enrollResponse == null || enrollResponse.getHttpStatus() != 200) {
                UserException userException = new UserException(69, "Aborting enrolling to cluster. Could not communicate with the node on any of the addresses from the enrollment token. All of " + enrollmentToken.getBoundAddress() + " were attempted.");
                try {
                    AutoConfigureNode.deleteDirectory(tempGeneratedTlsCertsDir);
                }
                catch (Exception ex) {
                    userException.addSuppressed((Throwable)ex);
                }
                throw userException;
            }
            Map responseMap = enrollResponse.getResponseBody();
            if (responseMap == null) {
                UserException userException = new UserException(65, "Aborting enrolling to cluster. Empty response when calling the enroll node API (" + enrollNodeUrl + ")");
                try {
                    AutoConfigureNode.deleteDirectory(tempGeneratedTlsCertsDir);
                }
                catch (Exception ex) {
                    userException.addSuppressed((Throwable)ex);
                }
                throw userException;
            }
            ArrayList<String> missingFields = new ArrayList<String>();
            String httpCaKeyPem = (String)responseMap.get("http_ca_key");
            if (Strings.isNullOrEmpty((String)httpCaKeyPem)) {
                missingFields.add("http_ca_key");
            }
            if (Strings.isNullOrEmpty((String)(httpCaCertPem = (String)responseMap.get("http_ca_cert")))) {
                missingFields.add("http_ca_cert");
            }
            if (Strings.isNullOrEmpty((String)(transportKeyPem = (String)responseMap.get("transport_key")))) {
                missingFields.add("transport_key");
            }
            if (Strings.isNullOrEmpty((String)(transportCaCertPem = (String)responseMap.get("transport_ca_cert")))) {
                missingFields.add("transport_ca_cert");
            }
            if (Strings.isNullOrEmpty((String)(transportCertPem = (String)responseMap.get("transport_cert")))) {
                missingFields.add("transport_cert");
            }
            if (null == (transportAddresses = AutoConfigureNode.getTransportAddresses(responseMap)) || transportAddresses.isEmpty()) {
                missingFields.add("nodes_addresses");
            }
            if (!missingFields.isEmpty()) {
                UserException userException = new UserException(65, "Aborting enrolling to cluster. Invalid response when calling the enroll node API (" + enrollNodeUrl + "). The following fields were empty or missing : " + missingFields);
                try {
                    AutoConfigureNode.deleteDirectory(tempGeneratedTlsCertsDir);
                }
                catch (Exception ex) {
                    userException.addSuppressed((Throwable)ex);
                }
                throw userException;
            }
            transportCaCert = AutoConfigureNode.parseCertificateFromPem(transportCaCertPem, terminal);
            httpCaKey = AutoConfigureNode.parseKeyFromPem(httpCaKeyPem, terminal);
            httpCaCert = AutoConfigureNode.parseCertificateFromPem(httpCaCertPem, terminal);
            transportKey = AutoConfigureNode.parseKeyFromPem(transportKeyPem, terminal);
            transportCert = AutoConfigureNode.parseCertificateFromPem(transportCertPem, terminal);
        } else {
            try {
                transportAddresses = List.of();
                KeyPair transportCaKeyPair = CertGenUtils.generateKeyPair(4096);
                PrivateKey transportCaKey = transportCaKeyPair.getPrivate();
                transportCaCert = CertGenUtils.generateSignedCertificate(transportCaPrincipal, null, transportCaKeyPair, null, null, true, 36135, SIGNATURE_ALGORITHM, null, Set.of());
                KeyPair transportKeyPair = CertGenUtils.generateKeyPair(4096);
                transportKey = transportKeyPair.getPrivate();
                transportCert = CertGenUtils.generateSignedCertificate(certificatePrincipal, null, transportKeyPair, transportCaCert, transportCaKey, false, 36135, SIGNATURE_ALGORITHM, null, Set.of());
                KeyPair httpCaKeyPair = CertGenUtils.generateKeyPair(4096);
                httpCaKey = httpCaKeyPair.getPrivate();
                httpCaCert = CertGenUtils.generateSignedCertificate(httpCaPrincipal, null, httpCaKeyPair, null, null, true, 1095, SIGNATURE_ALGORITHM, CertGenUtils.buildKeyUsage(HttpCertificateCommand.DEFAULT_CA_KEY_USAGE), Set.of());
            }
            catch (Throwable t) {
                try {
                    AutoConfigureNode.deleteDirectory(tempGeneratedTlsCertsDir);
                }
                catch (Exception ex) {
                    t.addSuppressed(ex);
                }
                throw t;
            }
        }
        try {
            KeyPair httpKeyPair = CertGenUtils.generateKeyPair(4096);
            httpKey = httpKeyPair.getPrivate();
            httpCert = CertGenUtils.generateSignedCertificate(certificatePrincipal, AutoConfigureNode.getSubjectAltNames(env.settings()), httpKeyPair, httpCaCert, httpCaKey, false, 730, SIGNATURE_ALGORITHM, CertGenUtils.buildKeyUsage(HttpCertificateCommand.DEFAULT_CERT_KEY_USAGE), Set.of(new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth)));
            AutoConfigureNode.fullyWriteFile(tempGeneratedTlsCertsDir, "http_ca.crt", false, this.inReconfigureMode ? ELASTICSEARCH_GROUP_OWNER : null, (CheckedConsumer<OutputStream, Exception>)((CheckedConsumer)stream -> {
                try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8)));){
                    pemWriter.writeObject((Object)httpCaCert);
                }
            }));
        }
        catch (Throwable t) {
            try {
                AutoConfigureNode.deleteDirectory(tempGeneratedTlsCertsDir);
            }
            catch (Exception ex) {
                t.addSuppressed(ex);
            }
            throw t;
        }
        Path keystoreBackupPath = env.configDir().resolve(String.format(Locale.ROOT, "elasticsearch.keystore.%d.orig", autoConfigDate.toInstant().getEpochSecond()));
        if (Files.exists(keystorePath, new LinkOption[0])) {
            try {
                Files.copy(keystorePath, keystoreBackupPath, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (Throwable t) {
                try {
                    AutoConfigureNode.deleteDirectory(tempGeneratedTlsCertsDir);
                }
                catch (Exception ex) {
                    t.addSuppressed(ex);
                }
                throw t;
            }
        }
        SetOnce nodeKeystorePassword = new SetOnce();
        try (KeyStoreWrapper nodeKeystore = KeyStoreWrapper.bootstrap((Path)env.configDir(), () -> {
            nodeKeystorePassword.set((Object)new SecureString(terminal.readSecret("")));
            return ((SecureString)nodeKeystorePassword.get()).clone();
        });){
            if (nodeKeystore.getSettingNames().contains("xpack.security.transport.ssl.keystore.secure_password") || nodeKeystore.getSettingNames().contains("xpack.security.transport.ssl.truststore.secure_password") || nodeKeystore.getSettingNames().contains("xpack.security.http.ssl.keystore.secure_password")) {
                throw new UserException(78, "Aborting auto configuration because the node keystore contains password settings already");
            }
            try (SecureString transportKeystorePassword = this.newKeystorePassword();){
                KeyStore transportKeystore = KeyStore.getInstance("PKCS12");
                transportKeystore.load(null);
                transportKeystore.setKeyEntry("transport", transportKey, transportKeystorePassword.getChars(), new Certificate[]{transportCert});
                transportKeystore.setCertificateEntry(TRANSPORT_CA_CERT_KEYSTORE_ENTRY, transportCaCert);
                AutoConfigureNode.fullyWriteFile(tempGeneratedTlsCertsDir, "transport.p12", false, this.inReconfigureMode ? ELASTICSEARCH_GROUP_OWNER : null, (CheckedConsumer<OutputStream, Exception>)((CheckedConsumer)stream -> transportKeystore.store((OutputStream)stream, transportKeystorePassword.getChars())));
                nodeKeystore.setString("xpack.security.transport.ssl.keystore.secure_password", transportKeystorePassword.getChars());
                nodeKeystore.setString("xpack.security.transport.ssl.truststore.secure_password", transportKeystorePassword.getChars());
            }
            try (SecureString httpKeystorePassword = this.newKeystorePassword();){
                KeyStore httpKeystore = KeyStore.getInstance("PKCS12");
                httpKeystore.load(null);
                httpKeystore.setKeyEntry("http_ca", httpCaKey, httpKeystorePassword.getChars(), new Certificate[]{httpCaCert});
                httpKeystore.setKeyEntry("http", httpKey, httpKeystorePassword.getChars(), new Certificate[]{httpCert, httpCaCert});
                AutoConfigureNode.fullyWriteFile(tempGeneratedTlsCertsDir, "http.p12", false, this.inReconfigureMode ? ELASTICSEARCH_GROUP_OWNER : null, (CheckedConsumer<OutputStream, Exception>)((CheckedConsumer)stream -> httpKeystore.store((OutputStream)stream, httpKeystorePassword.getChars())));
                nodeKeystore.setString("xpack.security.http.ssl.keystore.secure_password", httpKeystorePassword.getChars());
            }
            nodeKeystore.save(env.configDir(), nodeKeystorePassword.get() == null ? new char[]{} : ((SecureString)nodeKeystorePassword.get()).getChars());
        }
        catch (Throwable t) {
            try {
                if (Files.exists(keystoreBackupPath, new LinkOption[0])) {
                    Files.move(keystoreBackupPath, keystorePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.COPY_ATTRIBUTES);
                } else {
                    Files.deleteIfExists(keystorePath);
                }
            }
            catch (Exception ex) {
                t.addSuppressed(ex);
            }
            try {
                AutoConfigureNode.deleteDirectory(tempGeneratedTlsCertsDir);
            }
            catch (Exception ex) {
                t.addSuppressed(ex);
            }
            throw t;
        }
        finally {
            if (nodeKeystorePassword.get() != null) {
                ((SecureString)nodeKeystorePassword.get()).close();
            }
        }
        try {
            if (Files.exists(env.configDir().resolve(TLS_GENERATED_CERTS_DIR_NAME), new LinkOption[0])) {
                AutoConfigureNode.moveDirectory(env.configDir().resolve(TLS_GENERATED_CERTS_DIR_NAME), env.configDir().resolve(String.format(Locale.ROOT, "certs.%d.orig", autoConfigDate.toInstant().getEpochSecond())));
            }
            AutoConfigureNode.moveDirectory(tempGeneratedTlsCertsDir, env.configDir().resolve(TLS_GENERATED_CERTS_DIR_NAME));
        }
        catch (Throwable t) {
            try {
                if (Files.exists(keystoreBackupPath, new LinkOption[0])) {
                    Files.move(keystoreBackupPath, keystorePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.COPY_ATTRIBUTES);
                } else {
                    Files.deleteIfExists(keystorePath);
                }
            }
            catch (Exception ex) {
                t.addSuppressed(ex);
            }
            try {
                if (Files.exists(env.configDir().resolve(String.format(Locale.ROOT, "certs.%d.orig", autoConfigDate.toInstant().getEpochSecond())), new LinkOption[0])) {
                    AutoConfigureNode.moveDirectory(env.configDir().resolve(String.format(Locale.ROOT, "certs.%d.orig", autoConfigDate.toInstant().getEpochSecond())), env.configDir().resolve(TLS_GENERATED_CERTS_DIR_NAME));
                }
            }
            catch (Exception ex) {
                t.addSuppressed(ex);
            }
            try {
                AutoConfigureNode.deleteDirectory(tempGeneratedTlsCertsDir);
            }
            catch (Exception ex) {
                t.addSuppressed(ex);
            }
            throw t;
        }
        try {
            Environment localFinalEnv = env;
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss", Locale.ROOT);
            List<String> existingConfigLines = Files.readAllLines(ymlPath, StandardCharsets.UTF_8);
            AutoConfigureNode.fullyWriteFile(env.configDir(), "elasticsearch.yml", true, (CheckedConsumer<OutputStream, Exception>)((CheckedConsumer)stream -> {
                try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));){
                    for (String line : existingConfigLines) {
                        bw.write(line);
                        bw.newLine();
                    }
                    bw.newLine();
                    bw.write(AUTO_CONFIGURATION_START_MARKER);
                    bw.newLine();
                    bw.write("#");
                    bw.newLine();
                    bw.write("# The following settings, TLS certificates, and keys have been automatically      ");
                    bw.newLine();
                    bw.write("# generated to configure Elasticsearch security features on ");
                    bw.write(autoConfigDate.format(dateTimeFormatter));
                    bw.newLine();
                    bw.write("#");
                    bw.newLine();
                    bw.write("# --------------------------------------------------------------------------------");
                    bw.newLine();
                    bw.newLine();
                    bw.write("# Enable security features");
                    bw.newLine();
                    bw.write(XPackSettings.SECURITY_ENABLED.getKey() + ": true");
                    bw.newLine();
                    bw.newLine();
                    if (!(localFinalEnv.settings().hasValue(XPackSettings.ENROLLMENT_ENABLED.getKey()) && false == (Boolean)XPackSettings.ENROLLMENT_ENABLED.get(localFinalEnv.settings()))) {
                        bw.write(XPackSettings.ENROLLMENT_ENABLED.getKey() + ": true");
                        bw.newLine();
                        bw.newLine();
                    }
                    bw.write("# Enable encryption for HTTP API client connections, such as Kibana, Logstash, and Agents");
                    bw.newLine();
                    bw.write("xpack.security.http.ssl:");
                    bw.newLine();
                    bw.write("  enabled: true");
                    bw.newLine();
                    bw.write("  keystore.path: certs/http.p12");
                    bw.newLine();
                    bw.newLine();
                    bw.write("# Enable encryption and mutual authentication between cluster nodes");
                    bw.newLine();
                    bw.write("xpack.security.transport.ssl:");
                    bw.newLine();
                    bw.write("  enabled: true");
                    bw.newLine();
                    bw.write("  verification_mode: certificate");
                    bw.newLine();
                    bw.write("  keystore.path: certs/transport.p12");
                    bw.newLine();
                    bw.write("  truststore.path: certs/transport.p12");
                    if (inEnrollmentMode) {
                        bw.newLine();
                        bw.write("# Discover existing nodes in the cluster");
                        bw.newLine();
                        bw.write(SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.getKey() + ": [" + transportAddresses.stream().map(p -> "\"" + p + "\"").collect(Collectors.joining(", ")) + "]");
                        bw.newLine();
                    } else if (!DiscoveryModule.isSingleNodeDiscovery((Settings)localFinalEnv.settings()) && !ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.exists(localFinalEnv.settings())) {
                        bw.newLine();
                        bw.write("# Create a new cluster with the current node only");
                        bw.newLine();
                        bw.write("# Additional nodes can still join the cluster later");
                        bw.newLine();
                        bw.write(ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.getKey() + ": " + AutoConfigureNode.initialMasterNodesSettingValue(localFinalEnv));
                        bw.newLine();
                    }
                    if (!(localFinalEnv.settings().hasValue(HttpTransportSettings.SETTING_HTTP_HOST.getKey()) || localFinalEnv.settings().hasValue(HttpTransportSettings.SETTING_HTTP_BIND_HOST.getKey()) || localFinalEnv.settings().hasValue(HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.getKey()) || localFinalEnv.settings().hasValue(NetworkService.GLOBAL_NETWORK_HOST_SETTING.getKey()) || localFinalEnv.settings().hasValue(NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.getKey()) || localFinalEnv.settings().hasValue(NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.getKey()))) {
                        bw.newLine();
                        bw.write("# Allow HTTP API connections from anywhere");
                        bw.newLine();
                        bw.write("# Connections are encrypted and require user authentication");
                        bw.newLine();
                        bw.write(HttpTransportSettings.SETTING_HTTP_HOST.getKey() + ": 0.0.0.0");
                        bw.newLine();
                    }
                    if (!(localFinalEnv.settings().hasValue(TransportSettings.HOST.getKey()) || localFinalEnv.settings().hasValue(TransportSettings.BIND_HOST.getKey()) || localFinalEnv.settings().hasValue(TransportSettings.PUBLISH_HOST.getKey()) || localFinalEnv.settings().hasValue(NetworkService.GLOBAL_NETWORK_HOST_SETTING.getKey()) || localFinalEnv.settings().hasValue(NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.getKey()) || localFinalEnv.settings().hasValue(NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.getKey()))) {
                        bw.newLine();
                        bw.write("# Allow other nodes to join the cluster from anywhere");
                        bw.newLine();
                        bw.write("# Connections are encrypted and mutually authenticated");
                        bw.newLine();
                        if (!inEnrollmentMode || !AutoConfigureNode.anyRemoteHostNodeAddress(transportAddresses, NetworkUtils.getAllAddresses())) {
                            bw.write("#");
                        }
                        bw.write(TransportSettings.HOST.getKey() + ": 0.0.0.0");
                        bw.newLine();
                    }
                    bw.newLine();
                    bw.write(AUTO_CONFIGURATION_END_MARKER);
                    bw.newLine();
                }
            }));
        }
        catch (Throwable t) {
            try {
                if (Files.exists(keystoreBackupPath, new LinkOption[0])) {
                    Files.move(keystoreBackupPath, keystorePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                } else {
                    Files.deleteIfExists(keystorePath);
                }
            }
            catch (Exception ex) {
                t.addSuppressed(ex);
            }
            try {
                AutoConfigureNode.deleteDirectory(env.configDir().resolve(TLS_GENERATED_CERTS_DIR_NAME));
            }
            catch (Exception ex) {
                t.addSuppressed(ex);
            }
            Path backupCertsDir = env.configDir().resolve(String.format(Locale.ROOT, "certs.%d.orig", autoConfigDate.toInstant().getEpochSecond()));
            if (Files.exists(backupCertsDir, new LinkOption[0])) {
                AutoConfigureNode.moveDirectory(backupCertsDir, env.configDir().resolve(TLS_GENERATED_CERTS_DIR_NAME));
            }
            throw t;
        }
        if (Files.exists(keystoreBackupPath, new LinkOption[0])) {
            Files.delete(keystoreBackupPath);
        }
    }

    private static String initialMasterNodesSettingValue(Environment environment) {
        if (Node.NODE_NAME_SETTING.exists(environment.settings())) {
            return "[\"" + (String)Node.NODE_NAME_SETTING.get(environment.settings()) + "\"]";
        }
        return "[\"${HOSTNAME}\"]";
    }

    protected static boolean anyRemoteHostNodeAddress(List<String> allNodesTransportPublishAddresses, InetAddress[] allHostAddresses) {
        List<InetAddress> allAddressesList = Arrays.asList(allHostAddresses);
        for (String nodeStringAddress : allNodesTransportPublishAddresses) {
            try {
                URI uri = new URI("http://" + nodeStringAddress);
                InetAddress nodeAddress = InetAddress.getByName(uri.getHost());
                if (nodeAddress.isLoopbackAddress() || allAddressesList.contains(nodeAddress)) continue;
                return true;
            }
            catch (URISyntaxException | UnknownHostException exception) {
            }
        }
        return false;
    }

    private Environment possiblyReconfigureNode(Environment env, Terminal terminal, OptionSet options, ProcessInfo processInfo) throws UserException {
        List<String> existingConfigLines;
        try {
            existingConfigLines = Files.readAllLines(env.configDir().resolve("elasticsearch.yml"), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UserException(74, "Aborting enrolling to cluster. Unable to read elasticsearch.yml.", (Throwable)e);
        }
        List<String> existingConfigWithoutAutoconfiguration = AutoConfigureNode.removePreviousAutoconfiguration(existingConfigLines);
        if (!existingConfigLines.equals(existingConfigWithoutAutoconfiguration) && Files.exists(env.configDir().resolve(TLS_GENERATED_CERTS_DIR_NAME), new LinkOption[0])) {
            terminal.println((CharSequence)"");
            terminal.println((CharSequence)"This node will be reconfigured to join an existing cluster, using the enrollment token that you provided.");
            terminal.println((CharSequence)"This operation will overwrite the existing configuration. Specifically: ");
            terminal.println((CharSequence)"  - Security auto configuration will be removed from elasticsearch.yml");
            terminal.println((CharSequence)"  - The [certs] config directory will be removed");
            terminal.println((CharSequence)"  - Security auto configuration related secure settings will be removed from the elasticsearch.keystore");
            boolean shouldContinue = terminal.promptYesNo("Do you want to continue with the reconfiguration process", false);
            if (!shouldContinue) {
                throw new UserException(0, "User cancelled operation");
            }
            AutoConfigureNode.removeAutoConfigurationFromKeystore(env, terminal);
            try {
                AutoConfigureNode.fullyWriteFile(env.configDir(), "elasticsearch.yml", true, (CheckedConsumer<OutputStream, Exception>)((CheckedConsumer)stream -> {
                    try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));){
                        for (String l : existingConfigWithoutAutoconfiguration) {
                            bw.write(l);
                            bw.newLine();
                        }
                    }
                }));
                AutoConfigureNode.deleteDirectory(env.configDir().resolve(TLS_GENERATED_CERTS_DIR_NAME));
            }
            catch (Throwable t) {
                throw new UserException(74, "Aborting enrolling to cluster. Unable to remove existing security configuration.", t);
            }
            return this.createEnv(options, processInfo);
        }
        throw new UserException(64, "Aborting enrolling to cluster. This node doesn't appear to be auto-configured for security. Expected configuration is missing from elasticsearch.yml.");
    }

    private static void notifyOfFailure(boolean inEnrollmentMode, Terminal terminal, Terminal.Verbosity verbosity, int exitCode, String message) throws UserException {
        if (inEnrollmentMode) {
            throw new UserException(exitCode, message);
        }
        terminal.println(verbosity, (CharSequence)message);
        throw new UserException(exitCode, null);
    }

    private static void deleteDirectory(Path directory) throws IOException {
        IOUtils.rm((Path[])new Path[]{directory});
    }

    private static void moveDirectory(Path srcDir, Path dstDir) throws IOException {
        try {
            Files.move(srcDir, dstDir, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            Files.move(srcDir, dstDir, new CopyOption[0]);
        }
    }

    private static GeneralNames getSubjectAltNames(Settings settings) throws IOException {
        HashSet<GeneralName> generalNameSet = new HashSet<GeneralName>();
        for (InetAddress ip : NetworkUtils.getAllAddresses()) {
            String ipString = NetworkAddress.format((InetAddress)ip);
            generalNameSet.add(new GeneralName(7, ipString));
        }
        generalNameSet.add(new GeneralName(2, "localhost"));
        generalNameSet.add(new GeneralName(2, System.getenv("HOSTNAME")));
        for (List list : List.of(NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.exists(settings) ? (List)NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(settings) : List.of(), HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.exists(settings) ? (List)HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.get(settings) : List.of())) {
            for (String publishAddress : list) {
                if (InetAddresses.isInetAddress((String)publishAddress)) {
                    generalNameSet.add(new GeneralName(7, publishAddress));
                    continue;
                }
                generalNameSet.add(new GeneralName(2, publishAddress));
            }
        }
        return new GeneralNames(generalNameSet.toArray(new GeneralName[0]));
    }

    SecureString newKeystorePassword() {
        return UUIDs.randomBase64UUIDSecureString();
    }

    void checkExistingConfiguration(Settings settings, boolean inEnrollmentMode, Terminal terminal) throws UserException {
        if (!((Boolean)XPackSettings.SECURITY_AUTOCONFIGURATION_ENABLED.get(settings)).booleanValue()) {
            AutoConfigureNode.notifyOfFailure(inEnrollmentMode, terminal, Terminal.Verbosity.VERBOSE, 80, "Skipping security auto configuration because [" + XPackSettings.SECURITY_AUTOCONFIGURATION_ENABLED.getKey() + "] is false");
        }
        if (XPackSettings.SECURITY_ENABLED.exists(settings)) {
            AutoConfigureNode.notifyOfFailure(inEnrollmentMode, terminal, Terminal.Verbosity.VERBOSE, 80, "Skipping security auto configuration because it appears that security is already configured.");
        }
        if (!settings.getByPrefix(XPackSettings.TRANSPORT_SSL_PREFIX).isEmpty() || !settings.getByPrefix(XPackSettings.HTTP_SSL_PREFIX).isEmpty()) {
            AutoConfigureNode.notifyOfFailure(inEnrollmentMode, terminal, Terminal.Verbosity.VERBOSE, 80, "Skipping security auto configuration because it appears that TLS is already configured.");
        }
        if (!AutoConfigureNode.isInitialClusterNode(settings)) {
            AutoConfigureNode.notifyOfFailure(inEnrollmentMode, terminal, Terminal.Verbosity.VERBOSE, 80, "Skipping security auto configuration because this node is configured to bootstrap or to join a multi-node cluster, which is not supported.");
        }
        if (!inEnrollmentMode) {
            boolean canBecomeMaster;
            boolean bl = canBecomeMaster = DiscoveryNode.isMasterNode((Settings)settings) && false == DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.VOTING_ONLY_NODE_ROLE);
            if (!canBecomeMaster) {
                terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)"Skipping security auto configuration because the node is configured such that it cannot become master.");
                throw new UserException(80, null);
            }
            boolean canHoldSecurityIndex = DiscoveryNode.canContainData((Settings)settings);
            if (!canHoldSecurityIndex) {
                terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)"Skipping security auto configuration because the node is configured such that it cannot contain data.");
                throw new UserException(80, null);
            }
        }
    }

    private static boolean isInitialClusterNode(Settings settings) {
        return DiscoveryModule.isSingleNodeDiscovery((Settings)settings) || ((List)ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.get(settings)).isEmpty() && ((List)SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.get(settings)).isEmpty() && ((List)DiscoveryModule.DISCOVERY_SEED_PROVIDERS_SETTING.get(settings)).isEmpty() || ((List)ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.get(settings)).equals(List.of((String)Node.NODE_NAME_SETTING.get(settings)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fullyWriteFile(Path basePath, String fileName, boolean replace, @Nullable String groupOwner, CheckedConsumer<OutputStream, Exception> writer) throws Exception {
        PosixFileAttributeView view;
        Path filePath = basePath.resolve(fileName);
        if (!replace && Files.exists(filePath, new LinkOption[0])) {
            throw new UserException(74, String.format(Locale.ROOT, "Output file [%s] already exists and will not be replaced", filePath));
        }
        Set<PosixFilePermission> permission = PosixFilePermissions.fromString("rw-rw----");
        if (Files.exists(filePath, new LinkOption[0]) && (view = Files.getFileAttributeView(filePath, PosixFileAttributeView.class, new LinkOption[0])) != null) {
            permission = view.readAttributes().permissions();
        }
        Path tmpPath = basePath.resolve(fileName + "." + UUIDs.randomBase64UUID() + ".tmp");
        try (OutputStream outputStream = Files.newOutputStream(tmpPath, StandardOpenOption.CREATE_NEW);){
            writer.accept((Object)outputStream);
        }
        try {
            PosixFileAttributeView view2 = Files.getFileAttributeView(tmpPath, PosixFileAttributeView.class, new LinkOption[0]);
            if (view2 != null) {
                view2.setPermissions(permission);
                if (null != groupOwner) {
                    UserPrincipalLookupService lookupService = PathUtils.getDefaultFileSystem().getUserPrincipalLookupService();
                    GroupPrincipal groupPrincipal = lookupService.lookupPrincipalByGroupName(groupOwner);
                    view2.setGroup(groupPrincipal);
                }
            }
            if (replace) {
                Files.move(tmpPath, filePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            } else {
                Files.move(tmpPath, filePath, StandardCopyOption.ATOMIC_MOVE);
            }
        }
        finally {
            Files.deleteIfExists(tmpPath);
        }
    }

    private static void fullyWriteFile(Path basePath, String fileName, boolean replace, CheckedConsumer<OutputStream, Exception> writer) throws Exception {
        AutoConfigureNode.fullyWriteFile(basePath, fileName, replace, null, writer);
    }

    private static boolean isDirEmpty(Path path) throws IOException {
        try (Stream<Path> dirContentsStream = Files.list(path);){
            boolean bl = false == dirContentsStream.findAny().isPresent();
            return bl;
        }
    }

    private static X509Certificate parseCertificateFromPem(String pemFormattedCert, Terminal terminal) throws Exception {
        try {
            List certs = CertParsingUtils.readCertificates((InputStream)Base64.getDecoder().wrap(new ByteArrayInputStream(pemFormattedCert.getBytes(StandardCharsets.UTF_8))));
            if (certs.size() != 1) {
                throw new IllegalStateException("Enroll node API returned multiple certificates");
            }
            return (X509Certificate)certs.get(0);
        }
        catch (Exception e) {
            terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
            terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "Failed to parse Certificate from the response of the Enroll Node API: " + e.getMessage());
            terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
            terminal.errorPrintln(Terminal.Verbosity.VERBOSE, ExceptionsHelper.stackTrace((Throwable)e));
            terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
            throw new UserException(65, "Aborting enrolling to cluster. Failed to parse Certificate from the response of the Enroll Node API", (Throwable)e);
        }
    }

    private static PrivateKey parseKeyFromPem(String pemFormattedKey, Terminal terminal) throws UserException {
        try {
            return PemUtils.parsePKCS8PemString((String)pemFormattedKey);
        }
        catch (Exception e) {
            terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
            terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "Failed to parse Private Key from the response of the Enroll Node API: " + e.getMessage());
            terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
            terminal.errorPrintln(Terminal.Verbosity.VERBOSE, ExceptionsHelper.stackTrace((Throwable)e));
            terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
            throw new UserException(65, "Aborting enrolling to cluster. Failed to parse Private Key from the response of the Enroll Node API", (Throwable)e);
        }
    }

    private static List<String> getTransportAddresses(Map<String, Object> responseMap) {
        return (List)responseMap.get("nodes_addresses");
    }

    static List<String> removePreviousAutoconfiguration(List<String> existingConfigLines) throws UserException {
        String existingConfigurationAsString;
        Pattern pattern = Pattern.compile("(?s)(" + Pattern.quote(AUTO_CONFIGURATION_START_MARKER) + ".*?" + Pattern.quote(AUTO_CONFIGURATION_END_MARKER) + ")");
        Matcher matcher = pattern.matcher(existingConfigurationAsString = existingConfigLines.stream().collect(Collectors.joining(System.lineSeparator())));
        if (matcher.find()) {
            Settings foundAutoConfigurationSettings;
            String foundAutoConfigurationSettingsAsString = matcher.group(1);
            try {
                foundAutoConfigurationSettings = Settings.builder().loadFromSource(foundAutoConfigurationSettingsAsString, XContentType.YAML).build();
            }
            catch (Exception e) {
                throw new UserException(74, "Aborting enrolling to cluster. Unable to parse existing configuration file. Error was: " + e.getMessage(), (Throwable)e);
            }
            TreeSet<String> expectedAutoConfigurationSettings = new TreeSet<String>(List.of("xpack.security.enabled", "xpack.security.enrollment.enabled", "xpack.security.transport.ssl.keystore.path", "xpack.security.transport.ssl.truststore.path", "xpack.security.transport.ssl.verification_mode", "xpack.security.http.ssl.enabled", "xpack.security.transport.ssl.enabled", "xpack.security.http.ssl.keystore.path", "cluster.initial_master_nodes", "http.host"));
            HashSet userAddedSettings = new HashSet(foundAutoConfigurationSettings.keySet());
            userAddedSettings.removeAll(expectedAutoConfigurationSettings);
            List<String> newConfigurationLines = Arrays.stream(existingConfigurationAsString.replace(foundAutoConfigurationSettingsAsString, "").split(System.lineSeparator())).collect(Collectors.toList());
            if (!userAddedSettings.isEmpty()) {
                for (String key : userAddedSettings) {
                    newConfigurationLines.add(key + ": " + foundAutoConfigurationSettings.get(key));
                }
            }
            return newConfigurationLines;
        }
        return existingConfigLines;
    }

    private static void removeAutoConfigurationFromKeystore(Environment env, Terminal terminal) throws UserException {
        if (Files.exists(KeyStoreWrapper.keystorePath((Path)env.configDir()), new LinkOption[0])) {
            try (KeyStoreWrapper existingKeystore = KeyStoreWrapper.load((Path)env.configDir());
                 SecureString keystorePassword = existingKeystore.hasPassword() ? new SecureString(terminal.readSecret("Enter password for the elasticsearch keystore: ")) : new SecureString(new char[0]);){
                existingKeystore.decrypt(keystorePassword.getChars());
                List<String> secureSettingsToRemove = List.of("xpack.security.transport.ssl.keystore.secure_password", "xpack.security.transport.ssl.truststore.secure_password", "xpack.security.http.ssl.keystore.secure_password", "autoconfiguration.password_hash");
                for (String setting : secureSettingsToRemove) {
                    if (!existingKeystore.getSettingNames().contains(setting)) {
                        throw new UserException(74, "Aborting enrolling to cluster. Unable to remove existing security configuration, elasticsearch.keystore did not contain expected setting [" + setting + "].");
                    }
                    existingKeystore.remove(setting);
                }
                existingKeystore.save(env.configDir(), keystorePassword.getChars());
            }
            catch (Exception e) {
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, ExceptionsHelper.stackTrace((Throwable)e));
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
                throw new UserException(74, "Aborting enrolling to cluster. Unable to remove existing secure settings. Error was: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

