/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.operator.comparison;

import java.io.IOException;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.ql.expression.gen.processor.FunctionalEnumBinaryProcessor;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.predicate.PredicateBiFunction;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Comparisons;

public class BinaryComparisonProcessor
extends FunctionalEnumBinaryProcessor<Object, Object, Boolean, BinaryComparisonOperation> {
    public static final String NAME = "cb";

    public BinaryComparisonProcessor(Processor left, Processor right, BinaryComparisonOperation operation) {
        super(left, right, operation);
    }

    public BinaryComparisonProcessor(StreamInput in) throws IOException {
        super(in, i -> (BinaryComparisonOperation)i.readEnum(BinaryComparisonOperation.class));
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object process(Object input) {
        if (this.function() == BinaryComparisonOperation.NULLEQ) {
            return this.doProcess(this.left().process(input), this.right().process(input));
        }
        return super.process(input);
    }

    public static enum BinaryComparisonOperation implements PredicateBiFunction<Object, Object, Boolean>
    {
        EQ(Comparisons::eq, "=="),
        NULLEQ(Comparisons::nulleq, "<=>"),
        NEQ(Comparisons::neq, "!="),
        GT(Comparisons::gt, ">"),
        GTE(Comparisons::gte, ">="),
        LT(Comparisons::lt, "<"),
        LTE(Comparisons::lte, "<=");

        private final BiFunction<Object, Object, Boolean> process;
        private final String symbol;

        private BinaryComparisonOperation(BiFunction<Object, Object, Boolean> process, String symbol) {
            this.process = process;
            this.symbol = symbol;
        }

        @Override
        public String symbol() {
            return this.symbol;
        }

        @Override
        public Boolean apply(Object left, Object right) {
            if (this != NULLEQ && (left == null || right == null)) {
                return null;
            }
            return this.doApply(left, right);
        }

        @Override
        public final Boolean doApply(Object left, Object right) {
            return this.process.apply(left, right);
        }

        public String toString() {
            return this.symbol;
        }
    }
}

