/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.search;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.async.GetAsyncStatusRequest;
import org.elasticsearch.xpack.core.search.action.GetAsyncStatusAction;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetAsyncStatusAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_async_search/status/{id}"));
    }

    public String getName() {
        return "async_search_status_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        GetAsyncStatusRequest statusRequest = new GetAsyncStatusRequest(request.param("id"));
        if (request.hasParam("keep_alive")) {
            statusRequest.setKeepAlive(request.paramAsTime("keep_alive", statusRequest.getKeepAlive()));
        }
        return channel -> client.execute((ActionType)GetAsyncStatusAction.INSTANCE, (ActionRequest)statusRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

