/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.cat;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestTable;
import org.elasticsearch.xpack.core.common.table.TableColumnAttributeBuilder;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.ml.rest.RestCompatibilityChecker;

@ServerlessScope(value=Scope.PUBLIC)
public class RestCatDatafeedsAction
extends AbstractCatAction {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "_cat/ml/datafeeds/{" + DatafeedConfig.ID + "}"), new RestHandler.Route(RestRequest.Method.GET, "_cat/ml/datafeeds"));
    }

    public String getName() {
        return "cat_ml_get_datafeeds_action";
    }

    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest restRequest, NodeClient client) {
        String datafeedId = restRequest.param(DatafeedConfig.ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)datafeedId)) {
            datafeedId = "_all";
        }
        GetDatafeedsStatsAction.Request request = new GetDatafeedsStatsAction.Request(datafeedId);
        RestCompatibilityChecker.checkAndSetDeprecatedParam("allow_no_datafeeds", "allow_no_match", RestApiVersion.V_7, restRequest, (r, s) -> r.paramAsBoolean(s, request.allowNoMatch()), arg_0 -> ((GetDatafeedsStatsAction.Request)request).setAllowNoMatch(arg_0));
        return channel -> client.execute((ActionType)GetDatafeedsStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestResponseListener<GetDatafeedsStatsAction.Response>(channel){

            public RestResponse buildResponse(GetDatafeedsStatsAction.Response getDatafeedsStatsRespons) throws Exception {
                return RestTable.buildResponse((Table)RestCatDatafeedsAction.this.buildTable(restRequest, getDatafeedsStatsRespons), (RestChannel)this.channel);
            }
        });
    }

    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/ml/datafeeds\n");
        sb.append("/_cat/ml/datafeeds/{datafeed_id}\n");
    }

    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"id", TableColumnAttributeBuilder.builder((String)"the datafeed_id").build());
        table.addCell((Object)"state", TableColumnAttributeBuilder.builder((String)"the datafeed state").setAliases(new String[]{"s"}).setTextAlignment(TableColumnAttributeBuilder.TextAlign.RIGHT).build());
        table.addCell((Object)"assignment_explanation", TableColumnAttributeBuilder.builder((String)"why the datafeed is or is not assigned to a node", (boolean)false).setAliases(new String[]{"ae"}).build());
        table.addCell((Object)"buckets.count", TableColumnAttributeBuilder.builder((String)"bucket count").setAliases(new String[]{"bc", "bucketsCount"}).build());
        table.addCell((Object)"search.count", TableColumnAttributeBuilder.builder((String)"number of searches ran by the datafeed").setAliases(new String[]{"sc", "searchCount"}).build());
        table.addCell((Object)"search.time", TableColumnAttributeBuilder.builder((String)"the total search time", (boolean)false).setAliases(new String[]{"st", "searchTime"}).build());
        table.addCell((Object)"search.bucket_avg", TableColumnAttributeBuilder.builder((String)"the average search time per bucket (millisecond)", (boolean)false).setAliases(new String[]{"sba", "searchBucketAvg"}).build());
        table.addCell((Object)"search.exp_avg_hour", TableColumnAttributeBuilder.builder((String)"the exponential average search time per hour (millisecond)", (boolean)false).setAliases(new String[]{"seah", "searchExpAvgHour"}).build());
        table.addCell((Object)"node.id", TableColumnAttributeBuilder.builder((String)"id of the assigned node", (boolean)false).setAliases(new String[]{"ni", "nodeId"}).build());
        table.addCell((Object)"node.name", TableColumnAttributeBuilder.builder((String)"name of the assigned node", (boolean)false).setAliases(new String[]{"nn", "nodeName"}).build());
        table.addCell((Object)"node.ephemeral_id", TableColumnAttributeBuilder.builder((String)"ephemeral id of the assigned node", (boolean)false).setAliases(new String[]{"ne", "nodeEphemeralId"}).build());
        table.addCell((Object)"node.address", TableColumnAttributeBuilder.builder((String)"network address of the assigned node", (boolean)false).setAliases(new String[]{"na", "nodeAddress"}).build());
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, GetDatafeedsStatsAction.Response dfStats) {
        Table table = this.getTableWithHeader(request);
        dfStats.getResponse().results().forEach(df -> {
            table.startRow();
            table.addCell((Object)df.getDatafeedId());
            table.addCell((Object)df.getDatafeedState().toString());
            table.addCell((Object)df.getAssignmentExplanation());
            DatafeedTimingStats timingStats = df.getTimingStats();
            table.addCell((Object)(timingStats == null ? 0L : timingStats.getBucketCount()));
            table.addCell((Object)(timingStats == null ? 0L : timingStats.getSearchCount()));
            table.addCell((Object)(timingStats == null ? TimeValue.timeValueMillis((long)0L) : TimeValue.timeValueMillis((long)((long)timingStats.getTotalSearchTimeMs()))));
            table.addCell((Object)(timingStats == null || timingStats.getBucketCount() == 0L ? 0.0 : timingStats.getAvgSearchTimePerBucketMs()));
            table.addCell((Object)(timingStats == null ? 0.0 : timingStats.getExponentialAvgSearchTimePerHourMs()));
            DiscoveryNode node = df.getNode();
            table.addCell((Object)(node == null ? null : node.getId()));
            table.addCell((Object)(node == null ? null : node.getName()));
            table.addCell((Object)(node == null ? null : node.getEphemeralId()));
            table.addCell(node == null ? null : node.getAddress().toString());
            table.endRow();
        });
        return table;
    }
}

