/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.process.ProcessBuilderUtils;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.ScheduledEventToRuleWriter;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.ProcessPipes;
import org.elasticsearch.xpack.ml.utils.FileUtils;

public class AutodetectBuilder {
    public static final String AUTODETECT = "autodetect";
    static final String AUTODETECT_PATH = "./autodetect";
    public static final String DELETE_STATE_FILES_ARG = "--deleteStateFiles";
    public static final String LENGTH_ENCODED_INPUT_ARG = "--lengthEncodedInput";
    public static final String MODEL_CONFIG_ARG = "--modelconfig=";
    public static final String QUANTILES_STATE_PATH_ARG = "--quantilesState=";
    public static final String LICENSE_KEY_VALIDATED_ARG = "--validElasticLicenseKeyConfirmed=";
    private static final String JSON_EXTENSION = ".json";
    private static final String CONFIG_ARG = "--config=";
    private static final String EVENTS_CONFIG_ARG = "--eventsconfig=";
    private static final String FILTERS_CONFIG_ARG = "--filtersconfig=";
    private static final int DEFAULT_MAX_NUM_RECORDS = 500;
    public static final Setting<Integer> MAX_ANOMALY_RECORDS_SETTING_DYNAMIC = Setting.intSetting((String)"xpack.ml.max_anomaly_records", (int)500, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final String QUANTILES_FILE_EXTENSION = ".json";
    private final Job job;
    private final List<Path> filesToDelete;
    private final Logger logger;
    private final Environment env;
    private final Settings settings;
    private final NativeController controller;
    private final ProcessPipes processPipes;
    private Set<MlFilter> referencedFilters;
    private List<ScheduledEvent> scheduledEvents;
    private Quantiles quantiles;

    public AutodetectBuilder(Job job, List<Path> filesToDelete, Logger logger, Environment env, Settings settings, NativeController controller, ProcessPipes processPipes) {
        this.env = env;
        this.settings = settings;
        this.controller = controller;
        this.processPipes = processPipes;
        this.job = Objects.requireNonNull(job);
        this.filesToDelete = Objects.requireNonNull(filesToDelete);
        this.logger = Objects.requireNonNull(logger);
        this.referencedFilters = new HashSet<MlFilter>();
        this.scheduledEvents = Collections.emptyList();
    }

    public AutodetectBuilder referencedFilters(Set<MlFilter> filters) {
        this.referencedFilters = filters;
        return this;
    }

    public AutodetectBuilder quantiles(Quantiles quantiles) {
        this.quantiles = quantiles;
        return this;
    }

    public AutodetectBuilder scheduledEvents(List<ScheduledEvent> scheduledEvents) {
        this.scheduledEvents = scheduledEvents;
        return this;
    }

    public void build() throws IOException, InterruptedException {
        List<String> command = this.buildAutodetectCommand();
        this.buildFiltersConfig(command);
        this.buildScheduledEventsConfig(command);
        this.buildJobConfig(command);
        this.buildQuantiles(command);
        this.processPipes.addArgs(command);
        this.controller.startProcess(command);
    }

    List<String> buildAutodetectCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(AUTODETECT_PATH);
        command.add(LENGTH_ENCODED_INPUT_ARG);
        command.add(AutodetectBuilder.maxAnomalyRecordsArg(this.settings));
        if (ProcessBuilderUtils.modelConfigFilePresent(this.env)) {
            String modelConfigFile = XPackPlugin.resolveConfigFile((Environment)this.env, (String)"mlmodel.conf").toString();
            command.add(MODEL_CONFIG_ARG + modelConfigFile);
        }
        command.add("--validElasticLicenseKeyConfirmed=true");
        return command;
    }

    static String maxAnomalyRecordsArg(Settings settings) {
        return "--maxAnomalyRecords=" + MAX_ANOMALY_RECORDS_SETTING_DYNAMIC.get(settings);
    }

    private void buildQuantiles(List<String> command) throws IOException {
        if (this.quantiles != null && !this.quantiles.getQuantileState().isEmpty()) {
            this.logger.info("Restoring quantiles for job '" + this.job.getId() + "'");
            Path normalizersStateFilePath = AutodetectBuilder.writeNormalizerInitState(this.job.getId(), this.quantiles.getQuantileState(), this.env);
            String quantilesStateFileArg = QUANTILES_STATE_PATH_ARG + normalizersStateFilePath;
            command.add(quantilesStateFileArg);
            command.add(DELETE_STATE_FILES_ARG);
        }
    }

    public static Path writeNormalizerInitState(String jobId, String state, Environment env) throws IOException {
        FileUtils.recreateTempDirectoryIfNeeded(env.tmpDir());
        Path stateFile = Files.createTempFile(env.tmpDir(), jobId + "_quantiles_" + Thread.currentThread().getId(), ".json", new FileAttribute[0]);
        try (BufferedWriter osw = Files.newBufferedWriter(stateFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            osw.write(state);
        }
        return stateFile;
    }

    private void buildScheduledEventsConfig(List<String> command) throws IOException {
        if (this.scheduledEvents.isEmpty()) {
            return;
        }
        FileUtils.recreateTempDirectoryIfNeeded(this.env.tmpDir());
        Path eventsConfigFile = Files.createTempFile(this.env.tmpDir(), "eventsConfig", ".json", new FileAttribute[0]);
        this.filesToDelete.add(eventsConfigFile);
        List scheduledEventToRuleWriters = this.scheduledEvents.stream().map(x -> new ScheduledEventToRuleWriter(x.getDescription(), x.toDetectionRule(this.job.getAnalysisConfig().getBucketSpan()))).collect(Collectors.toList());
        try (OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(eventsConfigFile, new OpenOption[0]), StandardCharsets.UTF_8);
             XContentBuilder jsonBuilder = JsonXContent.contentBuilder();){
            osw.write(Strings.toString((XContentBuilder)jsonBuilder.startObject().field(ScheduledEvent.RESULTS_FIELD.getPreferredName(), scheduledEventToRuleWriters).endObject()));
        }
        command.add(EVENTS_CONFIG_ARG + eventsConfigFile.toString());
    }

    private void buildJobConfig(List<String> command) throws IOException {
        FileUtils.recreateTempDirectoryIfNeeded(this.env.tmpDir());
        Path configFile = Files.createTempFile(this.env.tmpDir(), "config", ".json", new FileAttribute[0]);
        this.filesToDelete.add(configFile);
        try (OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(configFile, new OpenOption[0]), StandardCharsets.UTF_8);
             XContentBuilder jsonBuilder = JsonXContent.contentBuilder();){
            this.job.toXContent(jsonBuilder, ToXContent.EMPTY_PARAMS);
            osw.write(Strings.toString((XContentBuilder)jsonBuilder));
        }
        command.add(CONFIG_ARG + configFile.toString());
    }

    private void buildFiltersConfig(List<String> command) throws IOException {
        if (this.referencedFilters.isEmpty()) {
            return;
        }
        FileUtils.recreateTempDirectoryIfNeeded(this.env.tmpDir());
        Path filtersConfigFile = Files.createTempFile(this.env.tmpDir(), "filtersConfig", ".json", new FileAttribute[0]);
        this.filesToDelete.add(filtersConfigFile);
        try (OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(filtersConfigFile, new OpenOption[0]), StandardCharsets.UTF_8);
             XContentBuilder jsonBuilder = JsonXContent.contentBuilder();){
            osw.write(Strings.toString((XContentBuilder)jsonBuilder.startObject().field(MlFilter.RESULTS_FIELD.getPreferredName(), this.referencedFilters).endObject()));
        }
        command.add(FILTERS_CONFIG_ARG + filtersConfigFile.toString());
    }
}

