/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportMultiSearchAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.core.ml.annotations.Annotation;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.security.user.InternalUsers;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.retention.WritableIndexExpander;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;

public class JobDataDeleter {
    private static final Logger logger = LogManager.getLogger(JobDataDeleter.class);
    private static final int MAX_SNAPSHOTS_TO_DELETE = 10000;
    private final Client client;
    private final String jobId;
    private final boolean deleteUserAnnotations;

    public JobDataDeleter(Client client, String jobId) {
        this(client, jobId, false);
    }

    public JobDataDeleter(Client client, String jobId, boolean deleteUserAnnotations) {
        this.client = Objects.requireNonNull(client);
        this.jobId = Objects.requireNonNull(jobId);
        this.deleteUserAnnotations = deleteUserAnnotations;
    }

    public void deleteModelSnapshots(List<ModelSnapshot> modelSnapshots, ActionListener<BulkByScrollResponse> listener) {
        if (modelSnapshots.isEmpty()) {
            listener.onResponse((Object)JobDataDeleter.emptyBulkByScrollResponse());
            return;
        }
        String stateIndexName = AnomalyDetectorsIndex.jobStateIndexPattern();
        ArrayList<String> idsToDelete = new ArrayList<String>();
        HashSet<String> indices = new HashSet<String>();
        indices.add(stateIndexName);
        indices.add(".ml-annotations-read");
        for (ModelSnapshot modelSnapshot : modelSnapshots) {
            idsToDelete.addAll(modelSnapshot.stateDocumentIds());
            idsToDelete.add(ModelSnapshot.documentId((ModelSnapshot)modelSnapshot));
            idsToDelete.add(ModelSnapshot.annotationDocumentId((ModelSnapshot)modelSnapshot));
            indices.add(AnomalyDetectorsIndex.jobResultsAliasedName((String)modelSnapshot.getJobId()));
        }
        String[] indicesToQuery = this.removeReadOnlyIndices(new ArrayList<String>(indices), listener, "model snapshots", () -> listener.onResponse((Object)JobDataDeleter.emptyBulkByScrollResponse()));
        if (indicesToQuery.length == 0) {
            return;
        }
        DeleteByQueryRequest deleteByQueryRequest = ((DeleteByQueryRequest)new DeleteByQueryRequest(indicesToQuery).setRefresh(true)).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(idsToDelete.toArray(new String[0])));
        deleteByQueryRequest.getSearchRequest().source().sort("_doc");
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, listener);
    }

    private static BulkByScrollResponse emptyBulkByScrollResponse() {
        return new BulkByScrollResponse(TimeValue.ZERO, new BulkByScrollTask.Status(Collections.emptyList(), null), Collections.emptyList(), Collections.emptyList(), false);
    }

    public void deleteAllAnnotations(ActionListener<Boolean> listener) {
        this.deleteAnnotations(null, null, null, listener);
    }

    public void deleteAnnotations(@Nullable Long fromEpochMs, @Nullable Long toEpochMs, @Nullable Set<String> eventsToDelete, ActionListener<Boolean> listener) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)this.jobId));
        if (!this.deleteUserAnnotations) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)Annotation.CREATE_USERNAME.getPreferredName(), (String)InternalUsers.XPACK_USER.principal()));
        }
        if (fromEpochMs != null || toEpochMs != null) {
            boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)Annotation.TIMESTAMP.getPreferredName()).gte((Object)fromEpochMs).lt((Object)toEpochMs));
        }
        if (eventsToDelete != null && !eventsToDelete.isEmpty()) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)Annotation.EVENT.getPreferredName(), eventsToDelete));
        }
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((QueryBuilder)boolQuery);
        String[] indicesToQuery = this.removeReadOnlyIndices(List.of(".ml-annotations-read"), listener, "annotations", () -> listener.onResponse((Object)true));
        if (indicesToQuery.length == 0) {
            return;
        }
        DeleteByQueryRequest dbqRequest = (DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(indicesToQuery).setQuery((QueryBuilder)query).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setAbortOnVersionConflict(false)).setRefresh(true)).setSlices(0);
        dbqRequest.getSearchRequest().source().sort("_doc");
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)dbqRequest, (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)true), arg_0 -> listener.onFailure(arg_0)));
    }

    private <T> String[] removeReadOnlyIndices(List<String> indicesToQuery, ActionListener<T> listener, String entityType, Runnable onEmpty) {
        try {
            indicesToQuery = WritableIndexExpander.getInstance().getWritableIndices(indicesToQuery);
        }
        catch (Exception e) {
            logger.error("Failed to get writable indices for [" + this.jobId + "]", (Throwable)e);
            listener.onFailure(e);
            return new String[0];
        }
        if (indicesToQuery.isEmpty()) {
            logger.info("No writable {} indices found for [{}] job. No {} to remove.", (Object)entityType, (Object)this.jobId, (Object)entityType);
            if (onEmpty != null) {
                onEmpty.run();
            }
        }
        return (String[])indicesToQuery.toArray(String[]::new);
    }

    public void deleteResultsFromTime(long cutoffEpochMs, ActionListener<Boolean> listener) {
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)Result.RESULT_TYPE.getPreferredName(), (String[])new String[]{"record", "bucket", "bucket_influencer", "influencer", "model_plot"})).filter((QueryBuilder)QueryBuilders.rangeQuery((String)Result.TIMESTAMP.getPreferredName()).gte((Object)cutoffEpochMs));
        String[] indicesToQuery = this.removeReadOnlyIndices(List.of(AnomalyDetectorsIndex.jobResultsAliasedName((String)this.jobId)), listener, "results", () -> listener.onResponse((Object)true));
        if (indicesToQuery.length == 0) {
            return;
        }
        DeleteByQueryRequest dbqRequest = (DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(indicesToQuery).setQuery((QueryBuilder)query).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setAbortOnVersionConflict(false)).setRefresh(true)).setSlices(0);
        dbqRequest.getSearchRequest().source().sort("_doc");
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)dbqRequest, (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)true), arg_0 -> listener.onFailure(arg_0)));
    }

    public void deleteInterimResults() {
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.termQuery((String)Result.IS_INTERIM.getPreferredName(), (boolean)true));
        DeleteByQueryRequest dbqRequest = (DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)this.jobId)}).setQuery((QueryBuilder)query).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setAbortOnVersionConflict(false)).setRefresh(false)).setSlices(0);
        dbqRequest.getSearchRequest().source().sort("_doc");
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)dbqRequest).get();
        }
        catch (Exception e) {
            logger.error("[" + this.jobId + "] An error occurred while deleting interim results", (Throwable)e);
        }
    }

    public void deleteDatafeedTimingStats(ActionListener<BulkByScrollResponse> listener) {
        String[] indicesToQuery = this.removeReadOnlyIndices(List.of(AnomalyDetectorsIndex.jobResultsAliasedName((String)this.jobId)), listener, "datafeed timing stats", () -> listener.onResponse((Object)JobDataDeleter.emptyBulkByScrollResponse()));
        if (indicesToQuery.length == 0) {
            return;
        }
        DeleteByQueryRequest deleteByQueryRequest = ((DeleteByQueryRequest)new DeleteByQueryRequest(indicesToQuery).setRefresh(true)).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{DatafeedTimingStats.documentId((String)this.jobId)}));
        deleteByQueryRequest.getSearchRequest().source().sort("_doc");
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, listener);
    }

    public void deleteJobDocuments(JobConfigProvider jobConfigProvider, IndexNameExpressionResolver indexNameExpressionResolver, ClusterState clusterState, CheckedConsumer<Boolean, Exception> finishedHandler, Consumer<Exception> failureHandler) {
        AtomicReference indexNames = new AtomicReference();
        ActionListener completionHandler = ActionListener.wrap(response -> finishedHandler.accept((Object)response.isAcknowledged()), failureHandler);
        ActionListener dbqHandler = ActionListener.wrap(bulkByScrollResponse -> {
            if (bulkByScrollResponse == null) {
                completionHandler.onResponse((Object)IndicesAliasesResponse.ACKNOWLEDGED_NO_ERRORS);
            } else {
                if (bulkByScrollResponse.isTimedOut()) {
                    logger.warn("[{}] DeleteByQuery for indices [{}] timed out.", (Object)this.jobId, (Object)String.join((CharSequence)", ", (CharSequence[])indexNames.get()));
                }
                if (!bulkByScrollResponse.getBulkFailures().isEmpty()) {
                    logger.warn("[{}] {} failures and {} conflicts encountered while running DeleteByQuery on indices [{}].", (Object)this.jobId, (Object)bulkByScrollResponse.getBulkFailures().size(), (Object)bulkByScrollResponse.getVersionConflicts(), (Object)String.join((CharSequence)", ", (CharSequence[])indexNames.get()));
                    for (BulkItemResponse.Failure failure : bulkByScrollResponse.getBulkFailures()) {
                        logger.warn("DBQ failure: " + failure);
                    }
                }
                this.deleteAliases(this.jobId, (ActionListener<IndicesAliasesResponse>)completionHandler);
            }
        }, failureHandler);
        ActionListener deleteByQueryExecutor = ActionListener.wrap(response -> {
            if (response.booleanValue() && ((String[])indexNames.get()).length > 0) {
                this.deleteResultsByQuery(this.jobId, (String[])indexNames.get(), (ActionListener<BulkByScrollResponse>)dbqHandler);
            } else {
                dbqHandler.onResponse(null);
            }
        }, failureHandler);
        ActionListener customIndexSearchHandler = ActionListener.wrap(multiSearchResponse -> {
            if (multiSearchResponse == null) {
                deleteByQueryExecutor.onResponse((Object)true);
                return;
            }
            String defaultSharedIndex = ".ml-anomalies-shared";
            ArrayList<String> indicesToDelete = new ArrayList<String>();
            boolean needToRunDBQTemp = false;
            assert (multiSearchResponse.getResponses().length == ((String[])indexNames.get()).length);
            int i = 0;
            for (MultiSearchResponse.Item item : multiSearchResponse.getResponses()) {
                if (item.isFailure()) {
                    ++i;
                    if (ExceptionsHelper.unwrapCause((Throwable)item.getFailure()) instanceof IndexNotFoundException) continue;
                    failureHandler.accept(item.getFailure());
                    return;
                }
                SearchResponse searchResponse = item.getResponse();
                if (searchResponse.getHits().getTotalHits().value > 0L || ((String[])indexNames.get())[i].equals(defaultSharedIndex)) {
                    needToRunDBQTemp = true;
                } else {
                    indicesToDelete.add(((String[])indexNames.get())[i]);
                }
                ++i;
            }
            boolean needToRunDBQ = needToRunDBQTemp;
            if (indicesToDelete.isEmpty()) {
                deleteByQueryExecutor.onResponse((Object)needToRunDBQ);
                return;
            }
            logger.info("[{}] deleting the following indices directly {}", (Object)this.jobId, indicesToDelete);
            DeleteIndexRequest request = new DeleteIndexRequest((String[])indicesToDelete.toArray(String[]::new));
            request.indicesOptions(IndicesOptions.lenientExpandOpenHidden());
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (Object)request, (ActionListener)ActionListener.wrap(response -> deleteByQueryExecutor.onResponse((Object)needToRunDBQ), (Consumer)failureHandler), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).delete(arg_0, arg_1));
        }, failure -> {
            if (ExceptionsHelper.unwrapCause((Throwable)failure) instanceof IndexNotFoundException) {
                deleteByQueryExecutor.onResponse((Object)false);
            } else {
                failureHandler.accept((Exception)failure);
            }
        });
        ActionListener getJobHandler = ActionListener.wrap(builder -> {
            indexNames.set(indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)this.jobId)}));
            if (((String[])indexNames.get()).length == 0) {
                customIndexSearchHandler.onResponse(null);
                return;
            }
            MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
            for (String indexName : (String[])indexNames.get()) {
                SearchSourceBuilder source = new SearchSourceBuilder().size(0).trackTotalHitsUpTo(1).query((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)this.jobId))));
                multiSearchRequest.add(new SearchRequest(new String[]{indexName}).source(source));
            }
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)TransportMultiSearchAction.TYPE, (ActionRequest)multiSearchRequest, (ActionListener)customIndexSearchHandler);
        }, failureHandler);
        ActionListener deleteAnnotationsHandler = ActionListener.wrap(response -> jobConfigProvider.getJob(this.jobId, null, (ActionListener<Job.Builder>)getJobHandler), failureHandler);
        ActionListener deleteCategorizerStateHandler = ActionListener.wrap(response -> this.deleteAllAnnotations((ActionListener<Boolean>)deleteAnnotationsHandler), failureHandler);
        ActionListener deleteQuantilesHandler = ActionListener.wrap(response -> this.deleteCategorizerState(this.jobId, 1, (ActionListener<Boolean>)deleteCategorizerStateHandler), failureHandler);
        ActionListener deleteStateHandler = ActionListener.wrap(bulkResponse -> this.deleteQuantiles(this.jobId, (ActionListener<Boolean>)deleteQuantilesHandler), failureHandler);
        this.deleteModelState(this.jobId, (ActionListener<BulkByScrollResponse>)deleteStateHandler);
    }

    private void deleteResultsByQuery(String jobId, String[] indices, ActionListener<BulkByScrollResponse> listener) {
        assert (indices.length > 0);
        ActionListener refreshListener = ActionListener.wrap(refreshResponse -> {
            logger.info("[{}] running delete by query on [{}]", (Object)jobId, (Object)String.join((CharSequence)", ", indices));
            ConstantScoreQueryBuilder query = new ConstantScoreQueryBuilder((QueryBuilder)new TermQueryBuilder(Job.ID.getPreferredName(), jobId));
            String[] indicesToQuery = this.removeReadOnlyIndices(List.of(indices), listener, "results", () -> listener.onResponse((Object)JobDataDeleter.emptyBulkByScrollResponse()));
            if (indicesToQuery.length == 0) {
                return;
            }
            DeleteByQueryRequest request = (DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(indicesToQuery).setQuery((QueryBuilder)query).setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(IndicesOptions.lenientExpandOpenHidden())).setSlices(0)).setAbortOnVersionConflict(false)).setRefresh(true);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        }, arg_0 -> listener.onFailure(arg_0));
        RefreshRequest refreshRequest = new RefreshRequest(indices);
        refreshRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(IndicesOptions.lenientExpandOpenHidden()));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)RefreshAction.INSTANCE, (ActionRequest)refreshRequest, (ActionListener)refreshListener);
    }

    private void deleteAliases(String jobId, ActionListener<IndicesAliasesResponse> finishedHandler) {
        String readAliasName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        String writeAliasName = AnomalyDetectorsIndex.resultsWriteAlias((String)jobId);
        GetAliasesRequest aliasesRequest = new GetAliasesRequest().aliases(new String[]{readAliasName, writeAliasName}).indicesOptions(IndicesOptions.lenientExpandOpenHidden());
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (Object)aliasesRequest, (ActionListener)ActionListener.wrap(getAliasesResponse -> {
            IndicesAliasesRequest removeRequest = JobDataDeleter.buildRemoveAliasesRequest(getAliasesResponse);
            if (removeRequest == null) {
                finishedHandler.onResponse((Object)IndicesAliasesResponse.ACKNOWLEDGED_NO_ERRORS);
                return;
            }
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (Object)removeRequest, (ActionListener)finishedHandler, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).aliases(arg_0, arg_1));
        }, arg_0 -> finishedHandler.onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).getAliases(arg_0, arg_1));
    }

    private static IndicesAliasesRequest buildRemoveAliasesRequest(GetAliasesResponse getAliasesResponse) {
        HashSet aliases = new HashSet();
        ArrayList<String> indices = new ArrayList<String>();
        for (Map.Entry entry : getAliasesResponse.getAliases().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            indices.add((String)entry.getKey());
            ((List)entry.getValue()).forEach(metadata -> aliases.add(metadata.getAlias()));
        }
        return aliases.isEmpty() ? null : new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.remove().aliases(aliases.toArray(new String[0])).indices(indices.toArray(new String[0])));
    }

    private void deleteQuantiles(String jobId, ActionListener<Boolean> finishedHandler) {
        IdsQueryBuilder query = new IdsQueryBuilder().addIds(new String[]{Quantiles.documentId((String)jobId)});
        String[] indicesToQuery = this.removeReadOnlyIndices(List.of(AnomalyDetectorsIndex.jobStateIndexPattern()), finishedHandler, "quantiles", () -> finishedHandler.onResponse((Object)true));
        if (indicesToQuery.length == 0) {
            return;
        }
        DeleteByQueryRequest request = (DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(indicesToQuery).setQuery((QueryBuilder)query).setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen())).setAbortOnVersionConflict(false)).setRefresh(true);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> finishedHandler.onResponse((Object)true), JobDataDeleter.ignoreIndexNotFoundException(finishedHandler)));
    }

    private void deleteModelState(String jobId, ActionListener<BulkByScrollResponse> listener) {
        GetModelSnapshotsAction.Request request = new GetModelSnapshotsAction.Request(jobId, null);
        request.setPageParams(new PageParams(0, 10000));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetModelSnapshotsAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> {
            List deleteCandidates = response.getPage().results();
            this.deleteModelSnapshots(deleteCandidates, listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void deleteCategorizerState(String jobId, int docNum, ActionListener<Boolean> finishedHandler) {
        IdsQueryBuilder query = new IdsQueryBuilder().addIds(new String[]{CategorizerState.documentId((String)jobId, (int)docNum)});
        String[] indicesToQuery = this.removeReadOnlyIndices(List.of(AnomalyDetectorsIndex.jobStateIndexPattern()), finishedHandler, "categorizer state", () -> finishedHandler.onResponse((Object)true));
        if (indicesToQuery.length == 0) {
            return;
        }
        DeleteByQueryRequest request = (DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(indicesToQuery).setQuery((QueryBuilder)query).setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen())).setAbortOnVersionConflict(false)).setRefresh(true);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> {
            if (response.getDeleted() > 0L) {
                this.deleteCategorizerState(jobId, docNum + 1, finishedHandler);
                return;
            }
            finishedHandler.onResponse((Object)true);
        }, JobDataDeleter.ignoreIndexNotFoundException(finishedHandler)));
    }

    private static Consumer<Exception> ignoreIndexNotFoundException(ActionListener<Boolean> finishedHandler) {
        return e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
                finishedHandler.onResponse((Object)true);
            } else {
                finishedHandler.onFailure(e);
            }
        };
    }
}

