/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.pytorch.process;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xpack.ml.inference.pytorch.process.PyTorchProcess;
import org.elasticsearch.xpack.ml.inference.pytorch.process.PyTorchStateStreamer;
import org.elasticsearch.xpack.ml.inference.pytorch.results.PyTorchResult;
import org.elasticsearch.xpack.ml.process.BlackHoleResultIterator;

public class BlackHolePyTorchProcess
implements PyTorchProcess {
    private final ZonedDateTime startTime;
    private volatile boolean running = true;
    private final BlockingQueue<PyTorchResult> results = new LinkedBlockingDeque<PyTorchResult>();

    public BlackHolePyTorchProcess() {
        this.startTime = ZonedDateTime.now();
    }

    @Override
    public void loadModel(String modelId, String index, PyTorchStateStreamer stateStreamer, ActionListener<Boolean> listener) {
        listener.onResponse((Object)true);
    }

    @Override
    public Iterator<PyTorchResult> readResults() {
        return new BlackHoleResultIterator<PyTorchResult>(this.results, () -> this.running);
    }

    @Override
    public void writeInferenceRequest(BytesReference jsonRequest) throws IOException {
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void writeRecord(String[] record) throws IOException {
    }

    @Override
    public void persistState() throws IOException {
    }

    @Override
    public void persistState(long snapshotTimestampMs, String snapshotId, String snapshotDescription) throws IOException {
    }

    @Override
    public void flushStream() throws IOException {
    }

    @Override
    public void kill(boolean awaitCompletion) throws IOException {
        this.running = false;
    }

    @Override
    public ZonedDateTime getProcessStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isProcessAlive() {
        return this.running;
    }

    @Override
    public boolean isProcessAliveAfterWaiting() {
        try {
            Thread.sleep(45L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.running;
    }

    @Override
    public String readError() {
        return "";
    }

    @Override
    public void close() throws IOException {
        this.running = false;
    }
}

