/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.extractor;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.ml.extractor.AbstractField;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;
import org.elasticsearch.xpack.ml.extractor.SourceSupplier;

public class TimeField
extends AbstractField {
    static final Set<String> TYPES = Set.of("date", "date_nanos");
    private static final String EPOCH_MILLIS_FORMAT = "epoch_millis";
    private final ExtractedField.Method method;

    public TimeField(String name, ExtractedField.Method method) {
        super(name, TYPES);
        if (method == ExtractedField.Method.SOURCE) {
            throw new IllegalArgumentException("time field [" + name + "] cannot be extracted from source");
        }
        this.method = Objects.requireNonNull(method);
    }

    @Override
    public ExtractedField.Method getMethod() {
        return this.method;
    }

    @Override
    public Object[] value(SearchHit hit, SourceSupplier source) {
        Object[] value = this.getFieldValue(hit);
        if (value.length != 1) {
            return value;
        }
        Object object = value[0];
        if (object instanceof String) {
            String stringValue = (String)object;
            value[0] = TimeUtils.parseToEpochMs((String)stringValue);
        } else if (!(value[0] instanceof Long)) {
            throw new IllegalStateException("Unexpected value for a time field: " + value[0].getClass());
        }
        return value;
    }

    @Override
    public String getDocValueFormat() {
        if (this.method != ExtractedField.Method.DOC_VALUE) {
            throw new UnsupportedOperationException();
        }
        return EPOCH_MILLIS_FORMAT;
    }

    @Override
    public boolean supportsFromSource() {
        return false;
    }

    @Override
    public ExtractedField newFromSource() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMultiField() {
        return false;
    }
}

