/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.extractor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ml.extractor.DocValueField;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;
import org.elasticsearch.xpack.ml.extractor.SourceSupplier;

public class GeoPointField
extends DocValueField {
    static final String TYPE = "geo_point";
    private static final Set<String> TYPES = Collections.singleton("geo_point");

    public GeoPointField(String name) {
        super(name, TYPES);
    }

    @Override
    public Object[] value(SearchHit hit, SourceSupplier source) {
        Object[] value = super.value(hit, source);
        if (value.length == 0) {
            return value;
        }
        if (value.length > 1) {
            throw new IllegalStateException("Unexpected values for a geo_point field: " + Arrays.toString(value));
        }
        Object object = value[0];
        if (!(object instanceof String)) {
            throw new IllegalStateException("Unexpected value type for a geo_point field: " + value[0].getClass());
        }
        String stringValue = (String)object;
        value[0] = GeoPointField.handleString(stringValue);
        return value;
    }

    private static String handleString(String geoString) {
        if (geoString.contains(",")) {
            return geoString.replace(" ", "");
        }
        throw new IllegalArgumentException("Unexpected value for a geo_point field: " + geoString);
    }

    @Override
    public boolean supportsFromSource() {
        return false;
    }

    @Override
    public ExtractedField newFromSource() {
        throw new UnsupportedOperationException();
    }
}

