/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.extractor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Classification;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.FieldCardinalityConstraint;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Regression;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.RequiredField;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Types;
import org.elasticsearch.xpack.core.ml.dataframe.explain.FieldSelection;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NameResolver;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;
import org.elasticsearch.xpack.ml.extractor.ProcessedField;

public class ExtractedFieldsDetector {
    private static final Logger LOGGER = LogManager.getLogger(ExtractedFieldsDetector.class);
    private static final List<String> IGNORE_FIELDS = Collections.singletonList("ml__incremental_id");
    private final DataFrameAnalyticsConfig config;
    private final int docValueFieldsLimit;
    private final FieldCapabilitiesResponse fieldCapabilitiesResponse;
    private final Map<String, Long> cardinalitiesForFieldsWithConstraints;
    private final List<String> topNestedFieldPrefixes;

    ExtractedFieldsDetector(DataFrameAnalyticsConfig config, int docValueFieldsLimit, FieldCapabilitiesResponse fieldCapabilitiesResponse, Map<String, Long> cardinalitiesForFieldsWithConstraints) {
        this.config = Objects.requireNonNull(config);
        this.docValueFieldsLimit = docValueFieldsLimit;
        this.fieldCapabilitiesResponse = Objects.requireNonNull(fieldCapabilitiesResponse);
        this.cardinalitiesForFieldsWithConstraints = Objects.requireNonNull(cardinalitiesForFieldsWithConstraints);
        this.topNestedFieldPrefixes = this.findTopNestedFieldPrefixes(fieldCapabilitiesResponse);
    }

    private List<String> findTopNestedFieldPrefixes(FieldCapabilitiesResponse response) {
        List sortedNestedFieldPrefixes = response.get().keySet().stream().filter(field -> ExtractedFieldsDetector.isNested(this.getMappingTypes((String)field))).map(field -> field + ".").sorted().collect(Collectors.toList());
        Iterator iterator = sortedNestedFieldPrefixes.iterator();
        String previousNestedFieldPrefix = null;
        while (iterator.hasNext()) {
            String nestedFieldPrefix = (String)iterator.next();
            if (previousNestedFieldPrefix != null && nestedFieldPrefix.startsWith(previousNestedFieldPrefix)) {
                iterator.remove();
                continue;
            }
            previousNestedFieldPrefix = nestedFieldPrefix;
        }
        return Collections.unmodifiableList(sortedNestedFieldPrefixes);
    }

    public Tuple<ExtractedFields, List<FieldSelection>> detect() {
        List<ProcessedField> processedFields = this.extractFeatureProcessors().stream().map(ProcessedField::new).collect(Collectors.toList());
        TreeSet<FieldSelection> fieldSelection = new TreeSet<FieldSelection>(Comparator.comparing(FieldSelection::getName));
        Set<String> fields = this.getIncludedFields(fieldSelection, processedFields.stream().map(ProcessedField::getInputFieldNames).flatMap(Collection::stream).collect(Collectors.toSet()));
        this.checkFieldsHaveCompatibleTypes(fields);
        this.checkRequiredFields(fields);
        this.checkFieldsWithCardinalityLimit();
        ExtractedFields extractedFields = this.detectExtractedFields(fields, fieldSelection, processedFields);
        this.addIncludedFields(extractedFields, fieldSelection);
        ExtractedFieldsDetector.checkOutputFeatureUniqueness(processedFields, fields);
        return Tuple.tuple((Object)extractedFields, Collections.unmodifiableList(new ArrayList<FieldSelection>(fieldSelection)));
    }

    private Set<String> getIncludedFields(Set<FieldSelection> fieldSelection, Set<String> requiredFieldsForProcessors) {
        this.validateFieldsRequireForProcessors(requiredFieldsForProcessors);
        TreeSet<String> fields = new TreeSet<String>();
        this.fieldCapabilitiesResponse.get().keySet().stream().filter(f -> !this.fieldCapabilitiesResponse.isMetadataField(f) && !IGNORE_FIELDS.contains(f)).forEach(fields::add);
        this.removeFieldsUnderResultsField(fields);
        this.removeObjects(fields);
        this.applySourceFiltering(fields);
        if (!fields.containsAll(requiredFieldsForProcessors)) {
            throw ExceptionsHelper.badRequestException((String)"fields {} required by field_processors are not included in source filtering.", (Object[])new Object[]{Sets.difference(requiredFieldsForProcessors, fields)});
        }
        FetchSourceContext analyzedFields = this.config.getAnalyzedFields();
        if (analyzedFields == null || analyzedFields.includes().length == 0) {
            this.removeFieldsWithIncompatibleTypes(fields, fieldSelection);
        }
        this.includeAndExcludeFields(fields, fieldSelection);
        if (!fields.containsAll(requiredFieldsForProcessors)) {
            throw ExceptionsHelper.badRequestException((String)"fields {} required by field_processors are not included in the analyzed_fields.", (Object[])new Object[]{Sets.difference(requiredFieldsForProcessors, fields)});
        }
        return fields;
    }

    private void validateFieldsRequireForProcessors(Set<String> processorFields) {
        HashSet<String> fieldsForProcessor = new HashSet<String>(processorFields);
        this.removeFieldsUnderResultsField(fieldsForProcessor);
        if (fieldsForProcessor.size() < processorFields.size()) {
            throw ExceptionsHelper.badRequestException((String)"fields contained in results field [{}] cannot be used in a feature_processor", (Object[])new Object[]{this.config.getDest().getResultsField()});
        }
        this.removeObjects(fieldsForProcessor);
        if (fieldsForProcessor.size() < processorFields.size()) {
            throw ExceptionsHelper.badRequestException((String)"fields for feature_processors must not be objects or nested", (Object[])new Object[0]);
        }
        for (String string : fieldsForProcessor) {
            Optional<String> matchingNestedFieldPattern = this.findMatchingNestedFieldPattern(string);
            if (!matchingNestedFieldPattern.isPresent()) continue;
            throw ExceptionsHelper.badRequestException((String)"nested fields [{}] cannot be used in a feature_processor", (Object[])new Object[]{matchingNestedFieldPattern.get()});
        }
        ArrayList<String> errorFields = new ArrayList<String>();
        for (String fieldName : fieldsForProcessor) {
            if (!this.fieldCapabilitiesResponse.isMetadataField(fieldName) && !IGNORE_FIELDS.contains(fieldName)) continue;
            errorFields.add(fieldName);
        }
        if (!errorFields.isEmpty()) {
            throw ExceptionsHelper.badRequestException((String)"the following fields cannot be used in feature_processors {}", (Object[])new Object[]{errorFields});
        }
        List list = processorFields.stream().filter(f -> !this.fieldCapabilitiesResponse.get().containsKey(f)).collect(Collectors.toList());
        if (!list.isEmpty()) {
            throw ExceptionsHelper.badRequestException((String)"the fields {} were not found in the field capabilities of the source indices [{}]. Fields must exist and be mapped to be used in feature_processors.", (Object[])new Object[]{list, Strings.arrayToCommaDelimitedString((Object[])this.config.getSource().getIndex())});
        }
        List processedRequiredFields = this.config.getAnalysis().getRequiredFields().stream().map(RequiredField::getName).filter(processorFields::contains).collect(Collectors.toList());
        if (!processedRequiredFields.isEmpty()) {
            throw ExceptionsHelper.badRequestException((String)"required analysis fields {} cannot be used in a feature_processor", (Object[])new Object[]{processedRequiredFields});
        }
    }

    private void removeFieldsUnderResultsField(Set<String> fields) {
        String resultsFieldPrefix = this.config.getDest().getResultsField() + ".";
        Iterator<String> fieldsIterator = fields.iterator();
        while (fieldsIterator.hasNext()) {
            String field2 = fieldsIterator.next();
            if (!field2.startsWith(resultsFieldPrefix)) continue;
            fieldsIterator.remove();
        }
        fields.removeIf(field -> field.startsWith(resultsFieldPrefix));
    }

    private void removeObjects(Set<String> fields) {
        Iterator<String> fieldsIterator = fields.iterator();
        while (fieldsIterator.hasNext()) {
            String field = fieldsIterator.next();
            Set<String> types = this.getMappingTypes(field);
            if (!ExtractedFieldsDetector.isObject(types) && !ExtractedFieldsDetector.isNested(types)) continue;
            fieldsIterator.remove();
        }
    }

    private void applySourceFiltering(Set<String> fields) {
        Iterator<String> fieldsIterator = fields.iterator();
        while (fieldsIterator.hasNext()) {
            String field = fieldsIterator.next();
            if (!this.config.getSource().isFieldExcluded(field)) continue;
            fieldsIterator.remove();
        }
    }

    private void addExcludedField(String field, String reason, Set<FieldSelection> fieldSelection) {
        fieldSelection.add(FieldSelection.excluded((String)field, this.getMappingTypes(field), (String)reason));
    }

    private static void addExcludedNestedPattern(String pattern, Set<FieldSelection> fieldSelection) {
        fieldSelection.add(FieldSelection.excluded((String)pattern, Collections.singleton("nested"), (String)"nested fields are not supported"));
    }

    private Set<String> getMappingTypes(String field) {
        Map fieldCaps = this.fieldCapabilitiesResponse.getField(field);
        return fieldCaps == null ? Collections.emptySet() : fieldCaps.keySet();
    }

    private void removeFieldsWithIncompatibleTypes(Set<String> fields, Set<FieldSelection> fieldSelection) {
        Iterator<String> fieldsIterator = fields.iterator();
        while (fieldsIterator.hasNext()) {
            String field = fieldsIterator.next();
            Optional<String> matchingNestedFieldPattern = this.findMatchingNestedFieldPattern(field);
            if (matchingNestedFieldPattern.isPresent()) {
                ExtractedFieldsDetector.addExcludedNestedPattern(matchingNestedFieldPattern.get(), fieldSelection);
                fieldsIterator.remove();
                continue;
            }
            if (this.hasCompatibleType(field)) continue;
            this.addExcludedField(field, "unsupported type; supported types are " + this.getSupportedTypes(), fieldSelection);
            fieldsIterator.remove();
        }
    }

    private boolean hasCompatibleType(String field) {
        Map fieldCaps = this.fieldCapabilitiesResponse.getField(field);
        if (fieldCaps == null) {
            LOGGER.debug("[{}] incompatible field [{}] because it is missing from mappings", (Object)this.config.getId(), (Object)field);
            return false;
        }
        Set<String> fieldTypes = fieldCaps.keySet();
        if (Types.numerical().containsAll(fieldTypes)) {
            LOGGER.debug("[{}] field [{}] is compatible as it is numerical", (Object)this.config.getId(), (Object)field);
            return true;
        }
        if (this.config.getAnalysis().supportsCategoricalFields() && Types.categorical().containsAll(fieldTypes)) {
            LOGGER.debug("[{}] field [{}] is compatible as it is categorical", (Object)this.config.getId(), (Object)field);
            return true;
        }
        if (ExtractedFieldsDetector.isBoolean(fieldTypes)) {
            LOGGER.debug("[{}] field [{}] is compatible as it is boolean", (Object)this.config.getId(), (Object)field);
            return true;
        }
        LOGGER.debug("[{}] incompatible field [{}]; types {}; supported {}", (Object)this.config.getId(), (Object)field, fieldTypes, this.getSupportedTypes());
        return false;
    }

    private Set<String> getSupportedTypes() {
        TreeSet<String> supportedTypes = new TreeSet<String>(Types.numerical());
        if (this.config.getAnalysis().supportsCategoricalFields()) {
            supportedTypes.addAll(Types.categorical());
        }
        supportedTypes.add("boolean");
        return supportedTypes;
    }

    private Optional<String> findMatchingNestedFieldPattern(String field) {
        return this.topNestedFieldPrefixes.stream().filter(prefix -> field.startsWith((String)prefix)).map(prefix -> prefix + "*").findFirst();
    }

    private void includeAndExcludeFields(Set<String> fields, Set<FieldSelection> fieldSelection) {
        FetchSourceContext analyzedFields = this.config.getAnalyzedFields();
        if (analyzedFields == null) {
            return;
        }
        this.checkIncludesExcludesAreNotObjects(analyzedFields);
        String includes = analyzedFields.includes().length == 0 ? "*" : Strings.arrayToCommaDelimitedString((Object[])analyzedFields.includes());
        String excludes = Strings.arrayToCommaDelimitedString((Object[])analyzedFields.excludes());
        if (Regex.isMatchAllPattern((String)includes) && excludes.isEmpty()) {
            return;
        }
        try {
            String[] stringArray;
            if (analyzedFields.includes().length == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*";
            } else {
                stringArray = analyzedFields.includes();
            }
            Set<String> includedSet = ExtractedFieldsDetector.expandFields(stringArray, fields, false);
            Set<String> excludedSet = ExtractedFieldsDetector.expandFields(analyzedFields.excludes(), this.fieldCapabilitiesResponse.get().keySet(), true);
            this.applyIncludesExcludes(fields, includedSet, excludedSet, fieldSelection);
        }
        catch (ResourceNotFoundException ex) {
            throw ExceptionsHelper.badRequestException((String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    private static Set<String> expandFields(String[] fields, Set<String> nameset, boolean allowNoMatch) {
        NameResolver nameResolver = NameResolver.newUnaliased(nameset, ex -> new ResourceNotFoundException(Messages.getMessage((String)"No field [{0}] could be detected", (Object[])new Object[]{ex}), new Object[0]));
        HashSet<String> expanded = new HashSet<String>();
        for (String field : fields) {
            expanded.addAll(nameResolver.expand(field, allowNoMatch));
        }
        return expanded;
    }

    private void checkIncludesExcludesAreNotObjects(FetchSourceContext analyzedFields) {
        List objectFields = Stream.concat(Arrays.stream(analyzedFields.includes()), Arrays.stream(analyzedFields.excludes())).filter(field -> ExtractedFieldsDetector.isObject(this.getMappingTypes((String)field)) || ExtractedFieldsDetector.isNested(this.getMappingTypes((String)field))).collect(Collectors.toList());
        if (!objectFields.isEmpty()) {
            throw ExceptionsHelper.badRequestException((String)"{} must not include or exclude object or nested fields: {}", (Object[])new Object[]{DataFrameAnalyticsConfig.ANALYZED_FIELDS.getPreferredName(), objectFields});
        }
    }

    private void applyIncludesExcludes(Set<String> fields, Set<String> includes, Set<String> excludes, Set<FieldSelection> fieldSelection) {
        Iterator<String> fieldsIterator = fields.iterator();
        while (fieldsIterator.hasNext()) {
            String field = fieldsIterator.next();
            if (includes.contains(field)) {
                if (this.fieldCapabilitiesResponse.isMetadataField(field) || IGNORE_FIELDS.contains(field)) {
                    throw ExceptionsHelper.badRequestException((String)"field [{}] cannot be analyzed", (Object[])new Object[]{field});
                }
                if (!excludes.contains(field)) continue;
                fieldsIterator.remove();
                this.addExcludedField(field, "field in excludes list", fieldSelection);
                continue;
            }
            fieldsIterator.remove();
            if (!this.hasCompatibleType(field)) {
                this.addExcludedField(field, "unsupported type; supported types are " + this.getSupportedTypes(), fieldSelection);
                continue;
            }
            Optional<String> matchingNestedFieldPattern = this.findMatchingNestedFieldPattern(field);
            if (matchingNestedFieldPattern.isPresent()) {
                ExtractedFieldsDetector.addExcludedNestedPattern(matchingNestedFieldPattern.get(), fieldSelection);
                continue;
            }
            this.addExcludedField(field, "field not in includes list", fieldSelection);
        }
    }

    private void checkFieldsHaveCompatibleTypes(Set<String> fields) {
        for (String field : fields) {
            Map fieldCaps = this.fieldCapabilitiesResponse.getField(field);
            if (fieldCaps == null) {
                throw ExceptionsHelper.badRequestException((String)"no mappings could be found for field [{}]", (Object[])new Object[]{field});
            }
            if (!this.hasCompatibleType(field)) {
                throw ExceptionsHelper.badRequestException((String)"field [{}] has unsupported type {}. Supported types are {}.", (Object[])new Object[]{field, fieldCaps.keySet(), this.getSupportedTypes()});
            }
            Optional<String> matchingNestedFieldPattern = this.findMatchingNestedFieldPattern(field);
            if (!matchingNestedFieldPattern.isPresent()) continue;
            throw ExceptionsHelper.badRequestException((String)"nested fields [{}] are not supported", (Object[])new Object[]{matchingNestedFieldPattern.get()});
        }
    }

    private void checkRequiredFields(Set<String> fields) {
        List requiredFields = this.config.getAnalysis().getRequiredFields();
        for (RequiredField requiredField : requiredFields) {
            Map fieldCaps = this.fieldCapabilitiesResponse.getField(requiredField.getName());
            if (!fields.contains(requiredField.getName()) || fieldCaps == null || fieldCaps.isEmpty()) {
                List requiredFieldNames = requiredFields.stream().map(RequiredField::getName).collect(Collectors.toList());
                throw ExceptionsHelper.badRequestException((String)"required field [{}] is missing; analysis requires fields {}", (Object[])new Object[]{requiredField.getName(), requiredFieldNames});
            }
            Set fieldTypes = fieldCaps.keySet();
            if (requiredField.getTypes().containsAll(fieldTypes)) continue;
            throw ExceptionsHelper.badRequestException((String)"invalid types {} for required field [{}]; expected types are {}", (Object[])new Object[]{fieldTypes, requiredField.getName(), requiredField.getTypes()});
        }
    }

    private void checkFieldsWithCardinalityLimit() {
        for (FieldCardinalityConstraint constraint : this.config.getAnalysis().getFieldCardinalityConstraints()) {
            constraint.check(this.cardinalitiesForFieldsWithConstraints.get(constraint.getField()).longValue());
        }
    }

    private List<PreProcessor> extractFeatureProcessors() {
        DataFrameAnalysis analysis = this.config.getAnalysis();
        if (analysis instanceof Classification) {
            Classification classification = (Classification)analysis;
            return classification.getFeatureProcessors();
        }
        if (analysis instanceof Regression) {
            Regression regression = (Regression)analysis;
            return regression.getFeatureProcessors();
        }
        return Collections.emptyList();
    }

    private ExtractedFields detectExtractedFields(Set<String> fields, Set<FieldSelection> fieldSelection, List<ProcessedField> processedFields) {
        ExtractedFields extractedFields = ExtractedFields.build(fields, Collections.emptySet(), Collections.emptySet(), this.fieldCapabilitiesResponse, this.cardinalitiesForFieldsWithConstraints, processedFields);
        boolean preferSource = extractedFields.getDocValueFields().size() > this.docValueFieldsLimit;
        extractedFields = this.deduplicateMultiFields(extractedFields, preferSource, fieldSelection);
        if (preferSource && (extractedFields = this.fetchFromSourceIfSupported(extractedFields)).getDocValueFields().size() > this.docValueFieldsLimit) {
            throw ExceptionsHelper.badRequestException((String)"[{}] fields must be retrieved from doc_values and this is greater than the configured limit. Please adjust the index level setting [{}]", (Object[])new Object[]{extractedFields.getDocValueFields().size(), IndexSettings.MAX_DOCVALUE_FIELDS_SEARCH_SETTING.getKey()});
        }
        extractedFields = this.fetchBooleanFieldsAsIntegers(extractedFields);
        return extractedFields;
    }

    private ExtractedFields deduplicateMultiFields(ExtractedFields extractedFields, boolean preferSource, Set<FieldSelection> fieldSelection) {
        Set<String> requiredFields = this.config.getAnalysis().getRequiredFields().stream().map(RequiredField::getName).collect(Collectors.toSet());
        Set<String> processorInputFields = extractedFields.getProcessedFieldInputs();
        LinkedHashMap<String, ExtractedField> nameOrParentToField = new LinkedHashMap<String, ExtractedField>();
        for (ExtractedField currentField : extractedFields.getAllFields()) {
            ExtractedField multiField;
            String nameOrParent = currentField.isMultiField() ? currentField.getParentField() : currentField.getName();
            ExtractedField existingField = nameOrParentToField.putIfAbsent(nameOrParent, currentField);
            if (existingField == null) continue;
            ExtractedField parent = currentField.isMultiField() ? existingField : currentField;
            ExtractedField extractedField = multiField = currentField.isMultiField() ? currentField : existingField;
            if (requiredFields.contains(parent.getName()) && processorInputFields.contains(multiField.getName()) || requiredFields.contains(multiField.getName()) && processorInputFields.contains(parent.getName())) {
                throw ExceptionsHelper.badRequestException((String)"feature_processors cannot be applied to required fields for analysis; multi-field [{}] parent [{}]", (Object[])new Object[]{multiField.getName(), parent.getName()});
            }
            if (processorInputFields.contains(parent.getName()) && processorInputFields.contains(multiField.getName())) {
                throw ExceptionsHelper.badRequestException((String)"feature_processors refer to both multi-field [{}] and parent [{}]. Please only refer to one or the other", (Object[])new Object[]{multiField.getName(), parent.getName()});
            }
            nameOrParentToField.put(nameOrParent, this.chooseMultiFieldOrParent(preferSource, requiredFields, processorInputFields, parent, multiField, fieldSelection));
        }
        return new ExtractedFields(new ArrayList<ExtractedField>(nameOrParentToField.values()), extractedFields.getProcessedFields(), this.cardinalitiesForFieldsWithConstraints);
    }

    private ExtractedField chooseMultiFieldOrParent(boolean preferSource, Set<String> requiredFields, Set<String> processorInputFields, ExtractedField parent, ExtractedField multiField, Set<FieldSelection> fieldSelection) {
        if (requiredFields.contains(parent.getName())) {
            this.addExcludedField(multiField.getName(), "[" + parent.getName() + "] is required instead", fieldSelection);
            return parent;
        }
        if (requiredFields.contains(multiField.getName())) {
            this.addExcludedField(parent.getName(), "[" + multiField.getName() + "] is required instead", fieldSelection);
            return multiField;
        }
        if (processorInputFields.contains(parent.getName())) {
            this.addExcludedField(multiField.getName(), "[" + parent.getName() + "] is referenced by feature_processors instead", fieldSelection);
            return parent;
        }
        if (processorInputFields.contains(multiField.getName())) {
            this.addExcludedField(parent.getName(), "[" + multiField.getName() + "] is referenced by feature_processors instead", fieldSelection);
            return multiField;
        }
        if (parent.isMultiField() && multiField.isMultiField()) {
            this.addExcludedField(multiField.getName(), "[" + parent.getName() + "] came first", fieldSelection);
            return parent;
        }
        if (preferSource && parent.supportsFromSource()) {
            this.addExcludedField(multiField.getName(), "[" + parent.getName() + "] is preferred because it supports fetching from source", fieldSelection);
            return parent;
        }
        if (parent.getMethod() == ExtractedField.Method.DOC_VALUE) {
            this.addExcludedField(multiField.getName(), "[" + parent.getName() + "] is preferred because it is aggregatable", fieldSelection);
            return parent;
        }
        if (multiField.getMethod() == ExtractedField.Method.DOC_VALUE) {
            this.addExcludedField(parent.getName(), "[" + multiField.getName() + "] is preferred because it is aggregatable", fieldSelection);
            return multiField;
        }
        this.addExcludedField(multiField.getName(), "[" + parent.getName() + "] is preferred because none of the multi-fields are aggregatable", fieldSelection);
        return parent;
    }

    private ExtractedFields fetchFromSourceIfSupported(ExtractedFields extractedFields) {
        ArrayList<ExtractedField> adjusted = new ArrayList<ExtractedField>(extractedFields.getAllFields().size());
        for (ExtractedField field : extractedFields.getAllFields()) {
            adjusted.add(field.supportsFromSource() ? field.newFromSource() : field);
        }
        return new ExtractedFields(adjusted, extractedFields.getProcessedFields(), this.cardinalitiesForFieldsWithConstraints);
    }

    private ExtractedFields fetchBooleanFieldsAsIntegers(ExtractedFields extractedFields) {
        ArrayList<ExtractedField> adjusted = new ArrayList<ExtractedField>(extractedFields.getAllFields().size());
        for (ExtractedField field : extractedFields.getAllFields()) {
            if (ExtractedFieldsDetector.isBoolean(field.getTypes())) {
                adjusted.add(ExtractedFields.applyBooleanMapping(field));
                continue;
            }
            adjusted.add(field);
        }
        return new ExtractedFields(adjusted, extractedFields.getProcessedFields(), this.cardinalitiesForFieldsWithConstraints);
    }

    private void addIncludedFields(ExtractedFields extractedFields, Set<FieldSelection> fieldSelection) {
        Set requiredFields = this.config.getAnalysis().getRequiredFields().stream().map(RequiredField::getName).collect(Collectors.toSet());
        Set<String> categoricalFields = ExtractedFieldsDetector.getCategoricalInputFields(extractedFields, this.config.getAnalysis());
        for (ExtractedField includedField : extractedFields.getAllFields()) {
            FieldSelection.FeatureType featureType = categoricalFields.contains(includedField.getName()) ? FieldSelection.FeatureType.CATEGORICAL : FieldSelection.FeatureType.NUMERICAL;
            fieldSelection.add(FieldSelection.included((String)includedField.getName(), includedField.getTypes(), (boolean)requiredFields.contains(includedField.getName()), (FieldSelection.FeatureType)featureType));
        }
    }

    static void checkOutputFeatureUniqueness(List<ProcessedField> processedFields, Set<String> selectedFields) {
        Set processInputs = processedFields.stream().map(ProcessedField::getInputFieldNames).flatMap(Collection::stream).collect(Collectors.toSet());
        Set organicFields = Sets.difference(selectedFields, processInputs);
        HashSet<String> processedFeatures = new HashSet<String>();
        HashSet<String> duplicatedFields = new HashSet<String>();
        for (ProcessedField processedField : processedFields) {
            for (String output : processedField.getOutputFieldNames()) {
                if (processedFeatures.add(output)) continue;
                duplicatedFields.add(output);
            }
        }
        if (!duplicatedFields.isEmpty()) {
            throw ExceptionsHelper.badRequestException((String)"feature_processors must define unique output field names; duplicate fields {}", (Object[])new Object[]{duplicatedFields});
        }
        Set duplicateOrganicAndProcessed = Sets.intersection((Set)organicFields, processedFeatures);
        if (!duplicateOrganicAndProcessed.isEmpty()) {
            throw ExceptionsHelper.badRequestException((String)"feature_processors output fields must not include non-processed analysis fields; duplicate fields {}", (Object[])new Object[]{duplicateOrganicAndProcessed});
        }
    }

    static Set<String> getCategoricalInputFields(ExtractedFields extractedFields, DataFrameAnalysis analysis) {
        return extractedFields.getAllFields().stream().filter(extractedField -> analysis.getAllowedCategoricalTypes(extractedField.getName()).containsAll(extractedField.getTypes())).map(ExtractedField::getName).collect(Collectors.toSet());
    }

    static Set<String> getCategoricalOutputFields(ExtractedFields extractedFields, DataFrameAnalysis analysis) {
        Set<String> processInputFields = extractedFields.getProcessedFieldInputs();
        Set categoricalFields = extractedFields.getAllFields().stream().filter(extractedField -> analysis.getAllowedCategoricalTypes(extractedField.getName()).containsAll(extractedField.getTypes())).map(ExtractedField::getName).filter(name -> !processInputFields.contains(name)).collect(Collectors.toSet());
        extractedFields.getProcessedFields().forEach(processedField -> processedField.getOutputFieldNames().forEach(outputField -> {
            if (analysis.getAllowedCategoricalTypes(outputField).containsAll(processedField.getOutputFieldType((String)outputField))) {
                categoricalFields.add(outputField);
            }
        }));
        return Collections.unmodifiableSet(categoricalFields);
    }

    private static boolean isBoolean(Set<String> types) {
        return types.size() == 1 && types.contains("boolean");
    }

    private static boolean isObject(Set<String> types) {
        return types.size() == 1 && types.contains("object");
    }

    private static boolean isNested(Set<String> types) {
        return types.size() == 1 && types.contains("nested");
    }
}

