/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;

public record MlMemoryAutoscalingCapacity(ByteSizeValue nodeSize, ByteSizeValue tierSize, String reason) {
    public static Builder builder(ByteSizeValue nodeSize, ByteSizeValue tierSize) {
        return new Builder(nodeSize, tierSize);
    }

    public static Builder from(AutoscalingCapacity autoscalingCapacity) {
        if (autoscalingCapacity == null) {
            return MlMemoryAutoscalingCapacity.builder(null, null);
        }
        return MlMemoryAutoscalingCapacity.builder(autoscalingCapacity.node().memory(), autoscalingCapacity.total().memory());
    }

    @Override
    public String toString() {
        return "MlMemoryAutoscalingCapacity{nodeSize=" + this.nodeSize + ", tierSize=" + this.tierSize + ", reason='" + this.reason + "'}";
    }

    public boolean isUndetermined() {
        return this.nodeSize == null && this.tierSize == null;
    }

    public static class Builder {
        private ByteSizeValue nodeSize;
        private ByteSizeValue tierSize;
        private String reason;

        public Builder(ByteSizeValue nodeSize, ByteSizeValue tierSize) {
            assert (nodeSize == null == (tierSize == null)) : "nodeSize " + nodeSize + " tierSize " + tierSize;
            this.nodeSize = nodeSize;
            this.tierSize = tierSize;
        }

        public Builder setReason(String reason) {
            this.reason = reason;
            return this;
        }

        public MlMemoryAutoscalingCapacity build() {
            return new MlMemoryAutoscalingCapacity(this.nodeSize, this.tierSize, this.reason);
        }
    }
}

