/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;

public class TransportUpdateDatafeedAction
extends TransportMasterNodeAction<UpdateDatafeedAction.Request, PutDatafeedAction.Response> {
    private final DatafeedManager datafeedManager;
    private final SecurityContext securityContext;

    @Inject
    public TransportUpdateDatafeedAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, DatafeedManager datafeedManager) {
        super("cluster:admin/xpack/ml/datafeeds/update", transportService, clusterService, threadPool, actionFilters, UpdateDatafeedAction.Request::new, PutDatafeedAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.datafeedManager = datafeedManager;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
    }

    protected void masterOperation(Task task, UpdateDatafeedAction.Request request, ClusterState state, ActionListener<PutDatafeedAction.Response> listener) {
        this.datafeedManager.updateDatafeed(request, state, this.securityContext, this.threadPool, listener);
    }

    protected ClusterBlockException checkBlock(UpdateDatafeedAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

