/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.AuditMlNotificationAction;
import org.elasticsearch.xpack.ml.notifications.AbstractMlAuditor;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;
import org.elasticsearch.xpack.ml.notifications.SystemAuditor;

public class TransportAuditMlNotificationAction
extends HandledTransportAction<AuditMlNotificationAction.Request, AcknowledgedResponse> {
    private final AnomalyDetectionAuditor anomalyDetectionAuditor;
    private final DataFrameAnalyticsAuditor dfaAuditor;
    private final InferenceAuditor inferenceAuditor;
    private final SystemAuditor systemAuditor;

    @Inject
    public TransportAuditMlNotificationAction(TransportService transportService, ActionFilters actionFilters, AnomalyDetectionAuditor anomalyDetectionAuditor, DataFrameAnalyticsAuditor dfaAuditor, InferenceAuditor inferenceAuditor, SystemAuditor systemAuditor) {
        super("cluster:internal/xpack/ml/notification", transportService, actionFilters, AuditMlNotificationAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.anomalyDetectionAuditor = anomalyDetectionAuditor;
        this.dfaAuditor = dfaAuditor;
        this.inferenceAuditor = inferenceAuditor;
        this.systemAuditor = systemAuditor;
    }

    protected void doExecute(Task task, AuditMlNotificationAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        AbstractMlAuditor auditor;
        switch (request.getAuditType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ANOMALY_DETECTION: {
                AbstractMlAuditor abstractMlAuditor = this.anomalyDetectionAuditor;
                break;
            }
            case DATAFRAME_ANALYTICS: {
                AbstractMlAuditor abstractMlAuditor = this.dfaAuditor;
                break;
            }
            case INFERENCE: {
                AbstractMlAuditor abstractMlAuditor = this.inferenceAuditor;
                break;
            }
            case SYSTEM: {
                AbstractMlAuditor abstractMlAuditor = auditor = this.systemAuditor;
            }
        }
        if (auditor != null) {
            auditor.audit(request.getLevel(), request.getId(), request.getMessage());
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
        } else {
            listener.onFailure((Exception)new IllegalStateException("Cannot find audit type for auditor [" + request.getAuditType() + "]"));
        }
    }
}

