/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto.content;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class ParsedMediaType {
    private static final Pattern TCHAR_PATTERN = Pattern.compile("[a-zA-Z0-9!#$%&'*+\\-.\\^_`|~]+");
    private final String originalHeaderValue;
    private final String type;
    private final String subType;
    private final Map<String, String> parameters;

    private ParsedMediaType(String originalHeaderValue, String type, String subType, Map<String, String> parameters) {
        this.originalHeaderValue = originalHeaderValue;
        this.type = type;
        this.subType = subType;
        this.parameters = Collections.unmodifiableMap(parameters);
    }

    public String mediaTypeWithoutParameters() {
        return this.type + "/" + this.subType;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public static ParsedMediaType parseMediaType(String headerValue) {
        if (headerValue != null) {
            if (ParsedMediaType.isMediaRange(headerValue) || "*/*".equals(headerValue)) {
                return null;
            }
            String[] elements = headerValue.toLowerCase(Locale.ROOT).split(";");
            String[] splitMediaType = elements[0].split("/");
            if (!(splitMediaType.length == 2 && TCHAR_PATTERN.matcher(splitMediaType[0].trim()).matches() && TCHAR_PATTERN.matcher(splitMediaType[1].trim()).matches())) {
                throw new IllegalArgumentException("invalid media-type [" + headerValue + "]");
            }
            if (elements.length == 1) {
                return new ParsedMediaType(headerValue, splitMediaType[0].trim(), splitMediaType[1].trim(), new HashMap<String, String>());
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (int i = 1; i < elements.length; ++i) {
                String paramsAsString = elements[i].trim();
                if (paramsAsString.isEmpty()) continue;
                String[] keyValueParam = paramsAsString.split("=");
                if (keyValueParam.length != 2 || ParsedMediaType.hasTrailingSpace(keyValueParam[0]) || ParsedMediaType.hasLeadingSpace(keyValueParam[1])) {
                    throw new IllegalArgumentException("invalid parameters for header [" + headerValue + "]");
                }
                String parameterName = keyValueParam[0].toLowerCase(Locale.ROOT).trim();
                String parameterValue = keyValueParam[1].toLowerCase(Locale.ROOT).trim();
                parameters.put(parameterName, parameterValue);
            }
            return new ParsedMediaType(headerValue, splitMediaType[0].trim().toLowerCase(Locale.ROOT), splitMediaType[1].trim().toLowerCase(Locale.ROOT), parameters);
        }
        return null;
    }

    private static boolean isMediaRange(String headerValue) {
        return headerValue.contains(",");
    }

    private static boolean hasTrailingSpace(String s) {
        return s.length() == 0 || Character.isWhitespace(s.charAt(s.length() - 1));
    }

    private static boolean hasLeadingSpace(String s) {
        return s.length() == 0 || Character.isWhitespace(s.charAt(0));
    }

    public String toString() {
        return this.originalHeaderValue;
    }

    public String responseContentTypeHeader() {
        return this.mediaTypeWithoutParameters() + ParsedMediaType.formatParameters(this.parameters);
    }

    private static String formatParameters(Map<String, String> params) {
        String joined = params.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(";"));
        return joined.isEmpty() ? "" : ";" + joined;
    }
}

