/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.RemoteClusterService;

public class RemoteClusterCredentialsManager {
    private static final Logger logger = LogManager.getLogger(RemoteClusterCredentialsManager.class);
    private volatile Map<String, SecureString> clusterCredentials = Collections.emptyMap();
    public static final RemoteClusterCredentialsManager EMPTY = new RemoteClusterCredentialsManager(Settings.EMPTY);

    public RemoteClusterCredentialsManager(Settings settings) {
        this.updateClusterCredentials(settings);
    }

    public final synchronized UpdateRemoteClusterCredentialsResult updateClusterCredentials(Settings settings) {
        Map<String, SecureString> newClusterCredentials = RemoteClusterService.REMOTE_CLUSTER_CREDENTIALS.getAsMap(settings);
        if (this.clusterCredentials.isEmpty()) {
            this.setClusterCredentialsAndLog(newClusterCredentials);
            return new UpdateRemoteClusterCredentialsResult(Set.copyOf(newClusterCredentials.keySet()), Collections.emptySet());
        }
        Set<String> addedClusterAliases = Sets.difference(newClusterCredentials.keySet(), this.clusterCredentials.keySet());
        Set<String> removedClusterAliases = Sets.difference(this.clusterCredentials.keySet(), newClusterCredentials.keySet());
        this.setClusterCredentialsAndLog(newClusterCredentials);
        assert (Sets.haveEmptyIntersection(removedClusterAliases, addedClusterAliases));
        return new UpdateRemoteClusterCredentialsResult(addedClusterAliases, removedClusterAliases);
    }

    @Nullable
    public SecureString resolveCredentials(String clusterAlias) {
        return this.clusterCredentials.get(clusterAlias);
    }

    public boolean hasCredentials(String clusterAlias) {
        return this.clusterCredentials.containsKey(clusterAlias);
    }

    private void setClusterCredentialsAndLog(Map<String, SecureString> newClusterCredentials) {
        this.clusterCredentials = newClusterCredentials;
        logger.debug(() -> Strings.format("Updated remote cluster credentials for clusters: [%s]", Strings.collectionToCommaDelimitedString(this.clusterCredentials.keySet())));
    }

    public record UpdateRemoteClusterCredentialsResult(Set<String> addedClusterAliases, Set<String> removedClusterAliases) {
    }
}

