/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.xcontent.ToXContent;

public record ThreadPoolStats(Collection<Stats> stats) implements Writeable,
ChunkedToXContent,
Iterable<Stats>
{
    public static final ThreadPoolStats IDENTITY = new ThreadPoolStats(List.of());

    public ThreadPoolStats {
        ArrayList<Stats> statsCopy = new ArrayList<Stats>(stats);
        Collections.sort(statsCopy);
        stats = Collections.unmodifiableList(statsCopy);
    }

    public ThreadPoolStats(StreamInput in) throws IOException {
        this(in.readCollectionAsList(Stats::new));
    }

    public static ThreadPoolStats merge(ThreadPoolStats first, ThreadPoolStats second) {
        HashMap mergedThreadPools = new HashMap();
        first.forEach(stats -> mergedThreadPools.merge(stats.name, stats, Stats::merge));
        second.forEach(stats -> mergedThreadPools.merge(stats.name, stats, Stats::merge));
        return new ThreadPoolStats(mergedThreadPools.values());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.stats);
    }

    @Override
    public Iterator<Stats> iterator() {
        return this.stats.iterator();
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(ChunkedToXContentHelper.startObject("thread_pool"), Iterators.flatMap(this.stats.iterator(), s -> s.toXContentChunked(params)), ChunkedToXContentHelper.endObject());
    }

    static final class Fields {
        static final String THREAD_POOL = "thread_pool";
        static final String THREADS = "threads";
        static final String QUEUE = "queue";
        static final String ACTIVE = "active";
        static final String REJECTED = "rejected";
        static final String LARGEST = "largest";
        static final String COMPLETED = "completed";

        Fields() {
        }
    }

    public record Stats(String name, int threads, int queue, int active, long rejected, int largest, long completed) implements Writeable,
    ChunkedToXContent,
    Comparable<Stats>
    {
        public Stats(StreamInput in) throws IOException {
            this(in.readString(), in.readInt(), in.readInt(), in.readInt(), in.readLong(), in.readInt(), in.readLong());
        }

        static Stats merge(Stats firstStats, Stats secondStats) {
            return new Stats(firstStats.name, Stats.sumStat(firstStats.threads, secondStats.threads), Stats.sumStat(firstStats.queue, secondStats.queue), Stats.sumStat(firstStats.active, secondStats.active), Stats.sumStat(firstStats.rejected, secondStats.rejected), Stats.sumStat(firstStats.largest, secondStats.largest), Stats.sumStat(firstStats.completed, secondStats.completed));
        }

        static int sumStat(int first, int second) {
            if (first == -1 && second == -1) {
                return -1;
            }
            if (first == -1) {
                return second;
            }
            if (second == -1) {
                return first;
            }
            return first + second;
        }

        static long sumStat(long first, long second) {
            if (first == -1L && second == -1L) {
                return -1L;
            }
            if (first == -1L) {
                return second;
            }
            if (second == -1L) {
                return first;
            }
            return first + second;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeInt(this.threads);
            out.writeInt(this.queue);
            out.writeInt(this.active);
            out.writeLong(this.rejected);
            out.writeInt(this.largest);
            out.writeLong(this.completed);
        }

        @Override
        public int compareTo(Stats other) {
            if (this.name() == null && other.name() == null) {
                return 0;
            }
            if (this.name() != null && other.name() == null) {
                return 1;
            }
            if (this.name() == null) {
                return -1;
            }
            int compare = this.name().compareTo(other.name());
            if (compare == 0) {
                compare = Integer.compare(this.threads(), other.threads());
            }
            return compare;
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
            return Iterators.concat(ChunkedToXContentHelper.startObject(this.name), this.threads != -1 ? Iterators.single((builder, params) -> builder.field("threads", this.threads)) : Collections.emptyIterator(), this.queue != -1 ? Iterators.single((builder, params) -> builder.field("queue", this.queue)) : Collections.emptyIterator(), this.active != -1 ? Iterators.single((builder, params) -> builder.field("active", this.active)) : Collections.emptyIterator(), this.rejected != -1L ? Iterators.single((builder, params) -> builder.field("rejected", this.rejected)) : Collections.emptyIterator(), this.largest != -1 ? Iterators.single((builder, params) -> builder.field("largest", this.largest)) : Collections.emptyIterator(), this.completed != -1L ? Iterators.single((builder, params) -> builder.field("completed", this.completed)) : Collections.emptyIterator(), ChunkedToXContentHelper.endObject());
        }
    }
}

