/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.queries.function.FunctionScoreQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.index.mapper.vectors.VectorSimilarityFloatValueSource;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.vectors.KnnScoreDocQuery;
import org.elasticsearch.search.vectors.QueryProfilerProvider;

public class RescoreKnnVectorQuery
extends Query
implements QueryProfilerProvider {
    private final String fieldName;
    private final float[] floatTarget;
    private final VectorSimilarityFunction vectorSimilarityFunction;
    private final int k;
    private final Query innerQuery;
    private long vectorOperations = 0L;

    public RescoreKnnVectorQuery(String fieldName, float[] floatTarget, VectorSimilarityFunction vectorSimilarityFunction, int k, Query innerQuery) {
        this.fieldName = fieldName;
        this.floatTarget = floatTarget;
        this.vectorSimilarityFunction = vectorSimilarityFunction;
        this.k = k;
        this.innerQuery = innerQuery;
    }

    public Query rewrite(IndexSearcher searcher) throws IOException {
        VectorSimilarityFloatValueSource valueSource = new VectorSimilarityFloatValueSource(this.fieldName, this.floatTarget, this.vectorSimilarityFunction);
        FunctionScoreQuery functionScoreQuery = new FunctionScoreQuery(this.innerQuery, (DoubleValuesSource)valueSource);
        Query query = searcher.rewrite((Query)functionScoreQuery);
        TopDocs topDocs = searcher.search(query, this.k);
        this.vectorOperations = topDocs.totalHits.value;
        return new KnnScoreDocQuery(topDocs.scoreDocs, searcher.getIndexReader());
    }

    public Query innerQuery() {
        return this.innerQuery;
    }

    public int k() {
        return this.k;
    }

    @Override
    public void profile(QueryProfiler queryProfiler) {
        Query query = this.innerQuery;
        if (query instanceof QueryProfilerProvider) {
            QueryProfilerProvider queryProfilerProvider = (QueryProfilerProvider)query;
            queryProfilerProvider.profile(queryProfiler);
        }
        queryProfiler.addVectorOpsCount(this.vectorOperations);
    }

    public void visit(QueryVisitor visitor) {
        this.innerQuery.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)this));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RescoreKnnVectorQuery that = (RescoreKnnVectorQuery)o;
        return Objects.equals(this.fieldName, that.fieldName) && Arrays.equals(this.floatTarget, that.floatTarget) && this.vectorSimilarityFunction == that.vectorSimilarityFunction && Objects.equals(this.k, that.k) && Objects.equals(this.innerQuery, that.innerQuery);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, Arrays.hashCode(this.floatTarget), this.vectorSimilarityFunction, this.k, this.innerQuery);
    }

    public String toString(String field) {
        return "KnnRescoreVectorQuery{fieldName='" + this.fieldName + "', floatTarget=" + this.floatTarget[0] + "..., vectorSimilarityFunction=" + this.vectorSimilarityFunction + ", k=" + this.k + ", vectorQuery=" + this.innerQuery + "}";
    }
}

