/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.fielddata.AbstractBinaryDocValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.BytesRefProducer;
import org.elasticsearch.script.BytesRefSortScript;
import org.elasticsearch.script.DocValuesDocReader;
import org.elasticsearch.script.NumberSortScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.StringSortScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortFieldAndFormat;
import org.elasticsearch.search.sort.SortMode;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ScriptSortBuilder
extends SortBuilder<ScriptSortBuilder> {
    public static final String NAME = "_script";
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    public static final ParseField SCRIPT_FIELD = new ParseField("script", new String[0]);
    public static final ParseField SORTMODE_FIELD = new ParseField("mode", new String[0]);
    private final Script script;
    private final ScriptSortType type;
    private SortMode sortMode;
    private NestedSortBuilder nestedSort;
    private DocValueFormat scriptResultValueFormat = DocValueFormat.RAW;
    private static final ConstructingObjectParser<ScriptSortBuilder, Void> PARSER = new ConstructingObjectParser("_script", a -> new ScriptSortBuilder((Script)a[0], (ScriptSortType)a[1]));

    public ScriptSortBuilder(Script script, ScriptSortType type) {
        Objects.requireNonNull(script, "script cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        this.script = script;
        this.type = type;
    }

    ScriptSortBuilder(ScriptSortBuilder original) {
        this.script = original.script;
        this.type = original.type;
        this.order = original.order;
        this.sortMode = original.sortMode;
        this.nestedSort = original.nestedSort;
    }

    public ScriptSortBuilder(StreamInput in) throws IOException {
        this.script = new Script(in);
        this.type = ScriptSortType.readFromStream(in);
        this.order = SortOrder.readFromStream(in);
        this.sortMode = in.readOptionalWriteable(SortMode::readFromStream);
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0) && (in.readOptionalNamedWriteable(QueryBuilder.class) != null || in.readOptionalString() != null)) {
            throw new IOException("the [sort] options [nested_path] and [nested_filter] are removed in 8.x, please use [nested] instead");
        }
        this.nestedSort = in.readOptionalWriteable(NestedSortBuilder::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
        this.type.writeTo(out);
        this.order.writeTo(out);
        out.writeOptionalWriteable(this.sortMode);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeOptionalString(null);
            out.writeOptionalNamedWriteable(null);
        }
        out.writeOptionalWriteable(this.nestedSort);
    }

    public Script script() {
        return this.script;
    }

    public ScriptSortType type() {
        return this.type;
    }

    public ScriptSortBuilder sortMode(SortMode sortMode) {
        Objects.requireNonNull(sortMode, "sort mode cannot be null.");
        if (ScriptSortType.STRING.equals(this.type) && (sortMode == SortMode.SUM || sortMode == SortMode.AVG || sortMode == SortMode.MEDIAN)) {
            throw new IllegalArgumentException("script sort of type [string] doesn't support mode [" + sortMode + "]");
        }
        this.sortMode = sortMode;
        return this;
    }

    public SortMode sortMode() {
        return this.sortMode;
    }

    public NestedSortBuilder getNestedSort() {
        return this.nestedSort;
    }

    public ScriptSortBuilder setNestedSort(NestedSortBuilder nestedSort) {
        this.nestedSort = nestedSort;
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(SCRIPT_FIELD.getPreferredName(), (ToXContent)this.script);
        builder.field(TYPE_FIELD.getPreferredName(), (Enum)this.type);
        builder.field(ORDER_FIELD.getPreferredName(), (Enum)this.order);
        if (this.sortMode != null) {
            builder.field(SORTMODE_FIELD.getPreferredName(), (Enum)this.sortMode);
        }
        if (this.nestedSort != null) {
            builder.field(NestedSortBuilder.NESTED_FIELD.getPreferredName(), (ToXContent)this.nestedSort);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static ScriptSortBuilder fromXContent(XContentParser parser, String elementName) {
        return (ScriptSortBuilder)PARSER.apply(parser, null);
    }

    @Override
    public SortFieldAndFormat build(SearchExecutionContext context) throws IOException {
        if ("version".equals(this.type.toString())) {
            try {
                MappedFieldType scriptFieldType = context.buildAnonymousFieldType(this.type.toString());
                this.scriptResultValueFormat = scriptFieldType.docValueFormat(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new SortFieldAndFormat(new SortField(NAME, (FieldComparatorSource)this.fieldComparatorSource(context), this.order == SortOrder.DESC), this.scriptResultValueFormat == null ? DocValueFormat.RAW : this.scriptResultValueFormat);
    }

    @Override
    public BucketedSort buildBucketedSort(SearchExecutionContext context, BigArrays bigArrays, int bucketSize, BucketedSort.ExtraData extra) throws IOException {
        return this.fieldComparatorSource(context).newBucketedSort(bigArrays, this.order, DocValueFormat.RAW, bucketSize, extra);
    }

    private IndexFieldData.XFieldComparatorSource fieldComparatorSource(SearchExecutionContext context) throws IOException {
        MultiValueMode valueMode = null;
        if (this.sortMode != null) {
            valueMode = MultiValueMode.fromString(this.sortMode.toString());
        }
        if (valueMode == null) {
            valueMode = this.order == SortOrder.DESC ? MultiValueMode.MAX : MultiValueMode.MIN;
        }
        IndexFieldData.XFieldComparatorSource.Nested nested = null;
        if (this.nestedSort != null) {
            FieldSortBuilder.validateMaxChildrenExistOnlyInTopLevelNestedSort(context, this.nestedSort);
            nested = ScriptSortBuilder.resolveNested(context, this.nestedSort);
        }
        final SearchLookup searchLookup = context.lookup();
        switch (this.type) {
            case STRING: {
                StringSortScript.Factory factory = context.compile(this.script, StringSortScript.CONTEXT);
                final StringSortScript.LeafFactory searchScript = factory.newFactory(this.script.getParams());
                return new BytesRefFieldComparatorSource(null, null, valueMode, nested){
                    final Map<Object, StringSortScript> leafScripts;
                    {
                        super(indexFieldData, missingValue, sortMode, nested);
                        this.leafScripts = ConcurrentCollections.newConcurrentMap();
                    }

                    @Override
                    protected SortedBinaryDocValues getValues(LeafReaderContext context) throws IOException {
                        final StringSortScript leafScript = searchScript.newInstance(new DocValuesDocReader(searchLookup, context));
                        this.leafScripts.put(context.id(), leafScript);
                        AbstractBinaryDocValues values = new AbstractBinaryDocValues(){
                            final BytesRefBuilder spare = new BytesRefBuilder();

                            public boolean advanceExact(int doc) {
                                leafScript.setDocument(doc);
                                return true;
                            }

                            public BytesRef binaryValue() {
                                this.spare.copyChars((CharSequence)leafScript.execute());
                                return this.spare.get();
                            }
                        };
                        return FieldData.singleton(values);
                    }

                    @Override
                    protected void setScorer(LeafReaderContext context, Scorable scorer) {
                        this.leafScripts.get(context.id()).setScorer(scorer);
                    }

                    @Override
                    public BucketedSort newBucketedSort(BigArrays bigArrays, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                        throw new IllegalArgumentException("error building sort for [_script]: script sorting only supported on [numeric] scripts but was [" + ScriptSortBuilder.this.type + "]");
                    }
                };
            }
            case NUMBER: {
                NumberSortScript.Factory numberSortFactory = context.compile(this.script, NumberSortScript.CONTEXT);
                final NumberSortScript.LeafFactory numberSortScriptFactory = numberSortFactory.newFactory(this.script.getParams(), searchLookup);
                return new DoubleValuesComparatorSource(null, Double.MAX_VALUE, valueMode, nested){
                    final Map<Object, NumberSortScript> leafScripts;
                    {
                        super(indexFieldData, missingValue, sortMode, nested);
                        this.leafScripts = ConcurrentCollections.newConcurrentMap();
                    }

                    @Override
                    protected SortedNumericDoubleValues getValues(LeafReaderContext context) throws IOException {
                        final NumberSortScript leafScript = numberSortScriptFactory.newInstance(new DocValuesDocReader(searchLookup, context));
                        this.leafScripts.put(context.id(), leafScript);
                        NumericDoubleValues values = new NumericDoubleValues(){

                            public boolean advanceExact(int doc) {
                                leafScript.setDocument(doc);
                                return true;
                            }

                            public double doubleValue() {
                                return leafScript.execute();
                            }
                        };
                        return FieldData.singleton(values);
                    }

                    @Override
                    protected void setScorer(LeafReaderContext context, Scorable scorer) {
                        this.leafScripts.get(context.id()).setScorer(scorer);
                    }
                };
            }
            case VERSION: {
                BytesRefSortScript.Factory factory = context.compile(this.script, BytesRefSortScript.CONTEXT);
                final BytesRefSortScript.LeafFactory searchScript = factory.newFactory(this.script.getParams());
                return new BytesRefFieldComparatorSource(null, null, valueMode, nested){
                    final Map<Object, BytesRefSortScript> leafScripts;
                    {
                        super(indexFieldData, missingValue, sortMode, nested);
                        this.leafScripts = ConcurrentCollections.newConcurrentMap();
                    }

                    @Override
                    protected SortedBinaryDocValues getValues(LeafReaderContext context) throws IOException {
                        final BytesRefSortScript leafScript = searchScript.newInstance(new DocValuesDocReader(searchLookup, context));
                        this.leafScripts.put(context.id(), leafScript);
                        AbstractBinaryDocValues values = new AbstractBinaryDocValues(){

                            public boolean advanceExact(int doc) {
                                leafScript.setDocument(doc);
                                return true;
                            }

                            public BytesRef binaryValue() {
                                Object result = leafScript.execute();
                                if (result == null) {
                                    return null;
                                }
                                if (result instanceof BytesRefProducer) {
                                    return ((BytesRefProducer)result).toBytesRef();
                                }
                                if (ScriptSortBuilder.this.scriptResultValueFormat == null) {
                                    throw new IllegalArgumentException("Invalid sort type: version");
                                }
                                return ScriptSortBuilder.this.scriptResultValueFormat.parseBytesRef(result);
                            }
                        };
                        return FieldData.singleton(values);
                    }

                    @Override
                    protected void setScorer(LeafReaderContext context, Scorable scorer) {
                        this.leafScripts.get(context.id()).setScorer(scorer);
                    }

                    @Override
                    public BucketedSort newBucketedSort(BigArrays bigArrays, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                        throw new IllegalArgumentException("error building sort for [_script]: script sorting only supported on [numeric] scripts but was [" + ScriptSortBuilder.this.type + "]");
                    }
                };
            }
        }
        throw new QueryShardException((QueryRewriteContext)context, "custom script sort type [" + this.type + "] not supported", new Object[0]);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScriptSortBuilder other = (ScriptSortBuilder)object;
        return Objects.equals(this.script, other.script) && Objects.equals(this.type, other.type) && Objects.equals(this.order, other.order) && Objects.equals(this.sortMode, other.sortMode) && Objects.equals(this.nestedSort, other.nestedSort);
    }

    public int hashCode() {
        return Objects.hash(this.script, this.type, this.order, this.sortMode, this.nestedSort);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    @Override
    public ScriptSortBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        if (this.nestedSort == null) {
            return this;
        }
        NestedSortBuilder rewrite = this.nestedSort.rewrite(ctx);
        if (this.nestedSort == rewrite) {
            return this;
        }
        return new ScriptSortBuilder(this).setNestedSort(rewrite);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> Script.parse(parser), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> ScriptSortType.fromString(p.text()), TYPE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareString((b, v) -> b.order(SortOrder.fromString(v)), ORDER_FIELD);
        PARSER.declareString((b, v) -> b.sortMode(SortMode.fromString(v)), SORTMODE_FIELD);
        PARSER.declareObject(ScriptSortBuilder::setNestedSort, (p, c) -> NestedSortBuilder.fromXContent(p), NestedSortBuilder.NESTED_FIELD);
        PARSER.declareObject((b, v) -> {}, (p, c) -> {
            throw new ParsingException(p.getTokenLocation(), "[nested_path] has been removed in favour of the [nested] parameter", c);
        }, NESTED_PATH_FIELD);
        PARSER.declareObject((b, v) -> {}, (p, c) -> {
            throw new ParsingException(p.getTokenLocation(), "[nested_filter] has been removed in favour of the [nested] parameter", c);
        }, NESTED_FILTER_FIELD);
    }

    public static enum ScriptSortType implements Writeable
    {
        STRING,
        NUMBER,
        VERSION;


        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        static ScriptSortType readFromStream(StreamInput in) throws IOException {
            return in.readEnum(ScriptSortType.class);
        }

        public static ScriptSortType fromString(String str) {
            Objects.requireNonNull(str, "input string is null");
            return switch (str.toLowerCase(Locale.ROOT)) {
                case "string" -> STRING;
                case "number" -> NUMBER;
                case "version" -> VERSION;
                default -> throw new IllegalArgumentException("Unknown ScriptSortType [" + str + "]");
            };
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

