/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.uhighlight.CustomSeparatorBreakIterator;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.lucene.search.uhighlight.BoundedBreakIteratorScanner;
import org.elasticsearch.lucene.search.uhighlight.CustomPassageFormatter;
import org.elasticsearch.lucene.search.uhighlight.CustomUnifiedHighlighter;
import org.elasticsearch.lucene.search.uhighlight.Snippet;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.FieldHighlightContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightUtils;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.LimitTokenOffsetAnalyzer;
import org.elasticsearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.xcontent.Text;

public class DefaultHighlighter
implements Highlighter {
    public static final String NAME = "unified";
    public static final NodeFeature UNIFIED_HIGHLIGHTER_MATCHED_FIELDS = new NodeFeature("unified_highlighter_matched_fields", true);

    @Override
    public boolean canHighlight(MappedFieldType fieldType) {
        return true;
    }

    @Override
    public HighlightField highlight(FieldHighlightContext fieldContext) throws IOException {
        Map cache = (Map)fieldContext.cache.computeIfAbsent(UnifiedHighlighter.class.getName(), k -> new HashMap());
        if (!cache.containsKey(fieldContext.fieldName)) {
            cache.put(fieldContext.fieldName, this.buildHighlighter(fieldContext));
        }
        CustomUnifiedHighlighter highlighter = (CustomUnifiedHighlighter)((Object)cache.get(fieldContext.fieldName));
        MappedFieldType fieldType = fieldContext.fieldType;
        SearchHighlightContext.Field field = fieldContext.field;
        FetchSubPhase.HitContext hitContext = fieldContext.hitContext;
        CheckedSupplier<String, IOException> loadFieldValues = () -> {
            List<Object> fieldValues = this.loadFieldValues(highlighter, fieldContext.context.getSearchExecutionContext(), fieldType, hitContext);
            if (fieldValues.size() == 0) {
                return null;
            }
            return DefaultHighlighter.mergeFieldValues(fieldValues, '\u0000');
        };
        Snippet[] fieldSnippets = highlighter.highlightField(hitContext.reader(), hitContext.docId(), loadFieldValues);
        if (fieldSnippets == null || fieldSnippets.length == 0) {
            return null;
        }
        ArrayList<Snippet> snippets = new ArrayList<Snippet>(fieldSnippets.length);
        for (Snippet fieldSnippet : fieldSnippets) {
            if (!Strings.hasText(fieldSnippet.getText())) continue;
            snippets.add(fieldSnippet);
        }
        if (snippets.isEmpty()) {
            return null;
        }
        if (field.fieldOptions().scoreOrdered().booleanValue()) {
            CollectionUtil.introSort(snippets, (o1, o2) -> Double.compare(o2.getScore(), o1.getScore()));
        }
        String[] fragments = new String[snippets.size()];
        for (int i = 0; i < fragments.length; ++i) {
            fragments[i] = ((Snippet)snippets.get(i)).getText();
        }
        return new HighlightField(fieldContext.fieldName, Text.convertFromStringArray((String[])fragments));
    }

    CustomUnifiedHighlighter buildHighlighter(FieldHighlightContext fieldContext) {
        int highlighterNumberOfFragments;
        Object breakIterator;
        IndexSettings indexSettings = fieldContext.context.getSearchExecutionContext().getIndexSettings();
        Encoder encoder = fieldContext.field.fieldOptions().encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
        int maxAnalyzedOffset = indexSettings.getHighlightMaxAnalyzedOffset();
        boolean weightMatchesEnabled = indexSettings.isWeightMatchesEnabled();
        int numberOfFragments = fieldContext.field.fieldOptions().numberOfFragments();
        Integer queryMaxAnalyzedOffset = fieldContext.field.fieldOptions().maxAnalyzedOffset();
        Analyzer analyzer = this.wrapAnalyzer(fieldContext.context.getSearchExecutionContext().getIndexAnalyzer(f -> Lucene.KEYWORD_ANALYZER), queryMaxAnalyzedOffset);
        PassageFormatter passageFormatter = this.getPassageFormatter(fieldContext.field, encoder);
        ContextIndexSearcher searcher = fieldContext.context.searcher();
        UnifiedHighlighter.OffsetSource offsetSource = DefaultHighlighter.getOffsetSource(fieldContext.context, fieldContext.fieldType);
        if (numberOfFragments == 0 || !fieldContext.fieldType.getTextSearchInfo().isTokenized()) {
            breakIterator = new CustomSeparatorBreakIterator('\u0000');
            highlighterNumberOfFragments = numberOfFragments == 0 ? 0x7FFFFFFE : numberOfFragments;
        } else {
            breakIterator = DefaultHighlighter.getBreakIterator(fieldContext.field);
            highlighterNumberOfFragments = numberOfFragments;
        }
        UnifiedHighlighter.Builder builder = UnifiedHighlighter.builder((IndexSearcher)searcher, (Analyzer)analyzer);
        builder.withBreakIterator(() -> DefaultHighlighter.lambda$buildHighlighter$4((BreakIterator)breakIterator));
        builder.withFormatter(passageFormatter);
        Set<String> matchedFields = fieldContext.field.fieldOptions().matchedFields();
        if (matchedFields != null && !matchedFields.isEmpty()) {
            if (!fieldContext.field.fieldOptions().requireFieldMatch().booleanValue()) {
                throw new IllegalArgumentException("Matched fields are not supported when [require_field_match] is set to [false]");
            }
            builder.withMaskedFieldsFunc(fieldName -> fieldName.equals(fieldContext.fieldName) ? matchedFields : Collections.emptySet());
        } else {
            builder.withFieldMatcher(DefaultHighlighter.fieldMatcher(fieldContext));
        }
        return new CustomUnifiedHighlighter(builder, offsetSource, fieldContext.field.fieldOptions().boundaryScannerLocale(), fieldContext.context.getIndexName(), fieldContext.fieldName, fieldContext.query, fieldContext.field.fieldOptions().noMatchSize(), highlighterNumberOfFragments, maxAnalyzedOffset, fieldContext.field.fieldOptions().maxAnalyzedOffset(), fieldContext.field.fieldOptions().requireFieldMatch(), weightMatchesEnabled);
    }

    protected PassageFormatter getPassageFormatter(SearchHighlightContext.Field field, Encoder encoder) {
        return new CustomPassageFormatter(field.fieldOptions().preTags()[0], field.fieldOptions().postTags()[0], encoder, field.fieldOptions().numberOfFragments());
    }

    protected Analyzer wrapAnalyzer(Analyzer analyzer, Integer maxAnalyzedOffset) {
        if (maxAnalyzedOffset != null) {
            analyzer = new LimitTokenOffsetAnalyzer((Analyzer)analyzer, maxAnalyzedOffset);
        }
        return analyzer;
    }

    protected List<Object> loadFieldValues(CustomUnifiedHighlighter highlighter, SearchExecutionContext searchContext, MappedFieldType fieldType, FetchSubPhase.HitContext hitContext) throws IOException {
        return HighlightUtils.loadFieldValues(fieldType, searchContext, hitContext).stream().map(s -> DefaultHighlighter.convertFieldValue(fieldType, s)).toList();
    }

    protected static BreakIterator getBreakIterator(SearchHighlightContext.Field field) {
        SearchHighlightContext.FieldOptions fieldOptions = field.fieldOptions();
        Locale locale = fieldOptions.boundaryScannerLocale() != null ? fieldOptions.boundaryScannerLocale() : Locale.ROOT;
        HighlightBuilder.BoundaryScannerType type = fieldOptions.boundaryScannerType() != null ? fieldOptions.boundaryScannerType() : HighlightBuilder.BoundaryScannerType.SENTENCE;
        int maxLen = fieldOptions.fragmentCharSize();
        switch (type) {
            case SENTENCE: {
                if (maxLen > 0) {
                    return BoundedBreakIteratorScanner.getSentence(locale, maxLen);
                }
                return BreakIterator.getSentenceInstance(locale);
            }
            case WORD: {
                return BreakIterator.getWordInstance(locale);
            }
        }
        throw new IllegalArgumentException("Invalid boundary scanner type: " + type);
    }

    public static String convertFieldValue(MappedFieldType type, Object value) {
        if (value instanceof BytesRef) {
            return type.valueForDisplay(value).toString();
        }
        return value.toString();
    }

    public static String mergeFieldValues(List<Object> fieldValues, char valuesSeparator) {
        String rawValue = Strings.collectionToDelimitedString(fieldValues, String.valueOf(valuesSeparator));
        return rawValue.substring(0, Math.min(rawValue.length(), 0x7FFFFFFE));
    }

    protected static UnifiedHighlighter.OffsetSource getOffsetSource(FetchContext fetchContext, MappedFieldType fieldType) {
        if (fetchContext.sourceLoader().reordersFieldValues()) {
            return UnifiedHighlighter.OffsetSource.ANALYSIS;
        }
        TextSearchInfo tsi = fieldType.getTextSearchInfo();
        if (tsi.hasOffsets()) {
            return tsi.termVectors() != TextSearchInfo.TermVector.NONE ? UnifiedHighlighter.OffsetSource.POSTINGS_WITH_TERM_VECTORS : UnifiedHighlighter.OffsetSource.POSTINGS;
        }
        if (tsi.termVectors() == TextSearchInfo.TermVector.OFFSETS) {
            return UnifiedHighlighter.OffsetSource.TERM_VECTORS;
        }
        return UnifiedHighlighter.OffsetSource.ANALYSIS;
    }

    private static Predicate<String> fieldMatcher(FieldHighlightContext fieldContext) {
        if (fieldContext.field.fieldOptions().requireFieldMatch().booleanValue()) {
            String fieldName = fieldContext.fieldName;
            return fieldName::equals;
        }
        return name -> !"_id".equals(name);
    }

    private static /* synthetic */ BreakIterator lambda$buildHighlighter$4(BreakIterator breakIterator) {
        return breakIterator;
    }
}

