/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.SimpleRefCounted;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.transport.LeakTracker;

public final class FetchSearchResult
extends SearchPhaseResult {
    private SearchHits hits;
    private transient int counter;
    private ProfileResult profileResult;
    private final RefCounted refCounted = LeakTracker.wrap((RefCounted)new SimpleRefCounted());

    public FetchSearchResult() {
    }

    public FetchSearchResult(ShardSearchContextId id, SearchShardTarget shardTarget) {
        this.contextId = id;
        this.setSearchShardTarget(shardTarget);
    }

    public FetchSearchResult(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
        this.hits = SearchHits.readFrom(in, true);
        this.profileResult = in.readOptionalWriteable(ProfileResult::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (this.hasReferences());
        this.contextId.writeTo(out);
        this.hits.writeTo(out);
        out.writeOptionalWriteable(this.profileResult);
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this;
    }

    public void shardResult(SearchHits hits, ProfileResult profileResult) {
        assert (FetchSearchResult.assertNoSearchTarget(hits));
        assert (this.hasReferences());
        SearchHits existing = this.hits;
        if (existing != null) {
            existing.decRef();
        }
        this.hits = hits;
        assert (this.profileResult == null);
        this.profileResult = profileResult;
    }

    private static boolean assertNoSearchTarget(SearchHits hits) {
        for (SearchHit hit : hits.getHits()) {
            assert (hit.getShard() == null) : "expected null but got: " + hit.getShard();
        }
        return true;
    }

    public SearchHits hits() {
        assert (this.hasReferences());
        return this.hits;
    }

    public FetchSearchResult initCounter() {
        this.counter = 0;
        return this;
    }

    public int counterGetAndIncrement() {
        return this.counter++;
    }

    public ProfileResult profileResult() {
        return this.profileResult;
    }

    @Override
    public void incRef() {
        this.refCounted.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.refCounted.tryIncRef();
    }

    @Override
    public boolean decRef() {
        if (this.refCounted.decRef()) {
            this.deallocate();
            return true;
        }
        return false;
    }

    private void deallocate() {
        if (this.hits != null) {
            this.hits.decRef();
            this.hits = null;
        }
    }

    @Override
    public boolean hasReferences() {
        return this.refCounted.hasReferences();
    }
}

