/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.Iterator;

public interface RankVectors {
    public static final RankVectors EMPTY = new RankVectors(){
        public static final String MISSING_VECTOR_FIELD_MESSAGE = "rank-vectors value missing for a field, use isEmpty() to check for a missing value";

        @Override
        public Iterator<float[]> getVectors() {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public float[] getMagnitudes() {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int getDims() {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public float maxSimDotProduct(float[][] query) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public float maxSimDotProduct(byte[][] query) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public float maxSimInvHamming(byte[][] query) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public int size() {
            return 0;
        }
    };

    default public void checkDimensions(int qvDims) {
        RankVectors.checkDimensions(this.getDims(), qvDims);
    }

    public float maxSimDotProduct(float[][] var1);

    public float maxSimDotProduct(byte[][] var1);

    public float maxSimInvHamming(byte[][] var1);

    public Iterator<float[]> getVectors();

    public float[] getMagnitudes();

    public boolean isEmpty();

    public int getDims();

    public int size();

    public static void checkDimensions(int dvDims, int qvDims) {
        if (dvDims != qvDims) {
            throw new IllegalArgumentException("The query vector has a different number of dimensions [" + qvDims + "] than the document vectors [" + dvDims + "].");
        }
    }

    private static String badQueryVectorType(Object queryVector) {
        return "Cannot use vector [" + queryVector + "] with class [" + queryVector.getClass().getName() + "] as query vector";
    }
}

